/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class TimeCanvas
extends Canvas {
    Calendar cal = Calendar.getInstance();
    private int minutes;
    private int hours;
    private int selected;

    public Date getTime() {
        this.cal.set(11, this.hours);
        this.cal.set(12, this.minutes);
        return this.cal.getTime();
    }

    public void setTime(Date time) {
        this.cal.setTime(time);
        this.hours = this.cal.get(11);
        this.minutes = this.cal.get(12);
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        int colorT;
        int colorR;
        int offset;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        g2.setColor(0xFFFFFF);
        g2.fillRect(0, 0, w2, h2);
        Font font = Font.getFont(32, 1, 0);
        String hoursStr = Integer.toString(this.hours);
        if (this.hours < 10) {
            hoursStr = "0" + hoursStr;
        }
        String minutesStr = Integer.toString(this.minutes);
        if (this.minutes < 10) {
            minutesStr = "0" + minutesStr;
        }
        String delimiterStr = " : ";
        int y2 = h2 - font.getHeight() >>> 1;
        int hoursW = font.stringWidth(hoursStr);
        int minutesW = font.stringWidth(minutesStr);
        int delimiterW = font.stringWidth(delimiterStr);
        int stringWidth = hoursW + minutesW + delimiterW;
        int hOff = offset = w2 - stringWidth >>> 1;
        int dOff = offset + hoursW;
        int mOff = dOff + delimiterW;
        g2.setColor(0);
        g2.setFont(font);
        g2.drawString(delimiterStr, dOff, y2, 20);
        if (this.selected == 0) {
            colorR = 0;
            colorT = 0xFFFFFF;
        } else {
            colorR = 0xFFFFFF;
            colorT = 0;
        }
        g2.setColor(colorR);
        g2.fillRect(hOff, y2, hoursW, font.getHeight());
        g2.setColor(colorT);
        g2.drawString(hoursStr, hOff, y2, 20);
        if (this.selected == 1) {
            colorR = 0;
            colorT = 0xFFFFFF;
        } else {
            colorR = 0xFFFFFF;
            colorT = 0;
        }
        g2.setColor(colorR);
        g2.fillRect(mOff, y2, minutesW, font.getHeight());
        g2.setColor(colorT);
        g2.drawString(minutesStr, mOff, y2, 20);
    }

    @Override
    public synchronized void keyPressed(int keycode) {
        int k2 = this.getGameAction(keycode);
        if (k2 == 2 && this.selected > 0) {
            --this.selected;
            this.repaint();
        } else if (k2 == 5 && this.selected < 1) {
            ++this.selected;
            this.repaint();
        } else if (k2 == 1) {
            switch (this.selected) {
                case 0: {
                    ++this.hours;
                    if (this.hours <= 23) break;
                    this.hours = 0;
                    break;
                }
                case 1: {
                    ++this.minutes;
                    if (this.minutes <= 59) break;
                    this.minutes = 0;
                }
            }
            this.repaint();
        } else if (k2 == 6) {
            switch (this.selected) {
                case 0: {
                    --this.hours;
                    if (this.hours >= 0) break;
                    this.hours = 23;
                    break;
                }
                case 1: {
                    --this.minutes;
                    if (this.minutes >= 0) break;
                    this.minutes = 59;
                }
            }
            this.repaint();
        }
    }
}

