/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.microemu.MIDletBridge;

class SampledAudioPlayer
implements Player,
LineListener {
    private AudioInputStream audioInputStream = null;
    private AudioInputStream decodedStream = null;
    private Clip clip = null;
    private Vector vListeners = null;
    private String strType = null;

    SampledAudioPlayer() {
    }

    public boolean open(InputStream stream, String type) {
        this.strType = type;
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(stream));
            AudioFormat format = this.audioInputStream.getFormat();
            if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                AudioFormat baseFormat = this.audioInputStream.getFormat();
                AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                this.decodedStream = AudioSystem.getAudioInputStream(decodedFormat, this.audioInputStream);
                int frameLength = (int)this.decodedStream.getFrameLength();
                int frameSize = decodedFormat.getFrameSize();
                DataLine.Info info = new DataLine.Info(Clip.class, decodedFormat, frameLength * frameSize);
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(this.decodedStream);
            } else {
                DataLine.Info info2 = new DataLine.Info(Clip.class, format, -1);
                this.clip = (Clip)AudioSystem.getLine(info2);
                this.clip.open(this.audioInputStream);
            }
        }
        catch (UnsupportedAudioFileException e2) {
            e2.printStackTrace();
            return false;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return false;
        }
        catch (LineUnavailableException e4) {
            e4.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void addPlayerListener(PlayerListener playerListener) {
        if (this.vListeners == null) {
            this.vListeners = new Vector();
        }
        this.vListeners.add(playerListener);
    }

    @Override
    public void close() {
        MIDletBridge.removeMediaPlayer(this);
        if (this.clip != null) {
            this.clip.flush();
            this.clip.close();
        }
        try {
            if (this.decodedStream != null) {
                this.decodedStream.close();
            }
            if (this.audioInputStream != null) {
                this.audioInputStream.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void deallocate() {
        if (this.clip != null) {
            this.clip.flush();
        }
    }

    @Override
    public String getContentType() {
        return this.strType;
    }

    @Override
    public long getDuration() {
        return 0L;
    }

    @Override
    public long getMediaTime() {
        if (this.clip != null) {
            return this.clip.getMicrosecondPosition();
        }
        return 0L;
    }

    @Override
    public int getState() {
        if (this.clip.isActive()) {
            return 400;
        }
        return 300;
    }

    @Override
    public void prefetch() throws MediaException {
    }

    @Override
    public void realize() throws MediaException {
    }

    @Override
    public void removePlayerListener(PlayerListener playerListener) {
        if (this.vListeners == null) {
            return;
        }
        for (PlayerListener listener : this.vListeners) {
            if (listener != playerListener) continue;
            this.vListeners.remove(listener);
            break;
        }
    }

    @Override
    public void setLoopCount(int count) {
        if (this.clip != null) {
            this.clip.loop(count);
        }
    }

    @Override
    public long setMediaTime(long now) throws MediaException {
        if (this.clip != null) {
            this.clip.setMicrosecondPosition(now);
        }
        return 0L;
    }

    @Override
    public void start() throws MediaException {
        if (this.clip != null) {
            this.clip.addLineListener(this);
            this.clip.start();
        }
    }

    @Override
    public void stop() throws MediaException {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    @Override
    public Control getControl(String controlType) {
        return null;
    }

    @Override
    public Control[] getControls() {
        return null;
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType().equals(LineEvent.Type.STOP)) {
            this.close();
            if (this.vListeners != null) {
                for (PlayerListener listener : this.vListeners) {
                    listener.playerUpdate(this, "endOfMedia", null);
                }
            }
        }
    }
}

