/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.microemu.DisplayComponent;
import org.microemu.EmulatorContext;
import org.microemu.MIDletBridge;
import org.microemu.app.Common;
import org.microemu.app.Config;
import org.microemu.app.ui.Message;
import org.microemu.app.ui.ResponseInterfaceListener;
import org.microemu.app.ui.StatusBarListener;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.app.ui.swt.SwtErrorMessageDialogPanel;
import org.microemu.app.ui.swt.SwtInputDialog;
import org.microemu.app.ui.swt.SwtMessageDialog;
import org.microemu.app.ui.swt.SwtSelectDeviceDialog;
import org.microemu.app.util.DeviceEntry;
import org.microemu.app.util.IOUtils;
import org.microemu.device.DeviceDisplay;
import org.microemu.device.DeviceFactory;
import org.microemu.device.FontManager;
import org.microemu.device.InputMethod;
import org.microemu.device.impl.DeviceImpl;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.swt.SwtDevice;
import org.microemu.device.swt.SwtDeviceDisplay;
import org.microemu.device.swt.SwtFontManager;
import org.microemu.device.swt.SwtInputMethod;

public class Swt
extends Common {
    public static Shell shell;
    protected static SwtDeviceComponent devicePanel;
    protected MenuItem menuOpenJADFile;
    protected MenuItem menuOpenJADURL;
    private SwtSelectDeviceDialog selectDeviceDialog;
    private FileDialog fileDialog = null;
    private MenuItem menuSelectDevice;
    private DeviceEntry deviceEntry;
    private Label statusBar;
    private KeyListener keyListener = new KeyListener(){

        public void keyTyped(KeyEvent e2) {
        }

        public void keyPressed(KeyEvent e2) {
        }

        public void keyReleased(KeyEvent e2) {
        }
    };
    protected Listener menuOpenJADFileListener = new Listener(){

        public void handleEvent(Event ev) {
            if (Swt.this.fileDialog == null) {
                Swt.this.fileDialog = new FileDialog(shell, 4096);
                Swt.this.fileDialog.setText("Open JAD File...");
                Swt.this.fileDialog.setFilterNames(new String[]{"JAD files"});
                Swt.this.fileDialog.setFilterExtensions(new String[]{"*.jad"});
                Swt.this.fileDialog.setFilterPath(Config.getRecentDirectory("recentJadDirectory"));
            }
            Swt.this.fileDialog.open();
            if (Swt.this.fileDialog.getFileName().length() > 0) {
                File selectedFile;
                if (Swt.this.fileDialog.getFilterPath() == null) {
                    selectedFile = new File(Swt.this.fileDialog.getFileName());
                } else {
                    selectedFile = new File(Swt.this.fileDialog.getFilterPath(), Swt.this.fileDialog.getFileName());
                    Config.setRecentDirectory("recentJadDirectory", Swt.this.fileDialog.getFilterPath());
                }
                String string = IOUtils.getCanonicalFileURL(selectedFile);
            }
        }
    };
    protected Listener menuOpenJADURLListener = new Listener(){

        public void handleEvent(Event ev) {
            SwtInputDialog inputDialog = new SwtInputDialog(shell, "Open...", "Enter JAD URL:");
            if (inputDialog.open() == 0) {
                System.err.println("Cannot load " + inputDialog.getValue());
            }
        }
    };
    protected Listener menuExitListener = new Listener(){

        public void handleEvent(Event e2) {
            Config.setWindow("main", new Rectangle(Swt.shell.getLocation().x, Swt.shell.getLocation().y, Swt.shell.getSize().x, Swt.shell.getSize().y), true);
            System.exit(0);
        }
    };
    private Listener menuSelectDeviceListener = new Listener(){

        public void handleEvent(Event e2) {
            if (Swt.this.selectDeviceDialog.open() == 0) {
                if (Swt.this.selectDeviceDialog.getSelectedDeviceEntry().equals(Swt.this.getDevice())) {
                    return;
                }
                if (MIDletBridge.getCurrentMIDlet() != Swt.this.getLauncher() && !SwtMessageDialog.openQuestion(shell, "Question?", "Changing device needs MIDlet to be restarted. All MIDlet data will be lost. Are you sure?")) {
                    return;
                }
                Swt.this.setDevice(Swt.this.selectDeviceDialog.getSelectedDeviceEntry());
                if (MIDletBridge.getCurrentMIDlet() != Swt.this.getLauncher()) {
                    try {
                        Swt.this.initMIDlet(true);
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                } else {
                    Swt.this.startLauncher(MIDletBridge.getMIDletContext());
                }
            }
        }
    };
    private StatusBarListener statusBarListener = new StatusBarListener(){

        @Override
        public void statusBarChanged(final String text) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Swt.this.statusBar.setText(text);
                }
            });
        }
    };
    private ResponseInterfaceListener responseInterfaceListener = new ResponseInterfaceListener(){

        @Override
        public void stateChanged(final boolean state) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).Swt.this.menuOpenJADFile.setEnabled(state);
                    (this).Swt.this.menuOpenJADURL.setEnabled(state);
                    Swt.this.menuSelectDevice.setEnabled(state);
                }
            });
        }
    };

    protected Swt(Shell shell) {
        this(shell, null);
    }

    protected Swt(Shell shell, DeviceEntry defaultDevice) {
        super(new EmulatorContext(){
            private InputMethod inputMethod = new SwtInputMethod();
            private DeviceDisplay deviceDisplay = new SwtDeviceDisplay(this);
            private FontManager fontManager = new SwtFontManager();

            @Override
            public DisplayComponent getDisplayComponent() {
                return devicePanel.getDisplayComponent();
            }

            @Override
            public InputMethod getDeviceInputMethod() {
                return this.inputMethod;
            }

            @Override
            public DeviceDisplay getDeviceDisplay() {
                return this.deviceDisplay;
            }

            @Override
            public FontManager getDeviceFontManager() {
                return this.fontManager;
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return MIDletBridge.getCurrentMIDlet().getClass().getResourceAsStream(name);
            }

            @Override
            public boolean platformRequest(final String URL2) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Message.info("MIDlet requests that the device handle the following URL: " + URL2);
                    }
                }).start();
                return false;
            }
        });
        this.initInterface(shell);
        Config.loadConfig(null, this.emulatorContext);
        this.loadImplementationsFromConfig();
        Rectangle window = Config.getWindow("main", new Rectangle(0, 0, 160, 120));
        shell.setLocation(window.x, window.y);
        shell.addKeyListener(this.keyListener);
        this.selectDeviceDialog = new SwtSelectDeviceDialog(shell, this.emulatorContext);
        this.setStatusBarListener(this.statusBarListener);
        this.setResponseInterfaceListener(this.responseInterfaceListener);
        Message.addListener(new SwtErrorMessageDialogPanel(shell));
    }

    protected void initInterface(Shell shell) {
        GridLayout layout = new GridLayout(1, false);
        shell.setLayout((Layout)layout);
        shell.setLayoutData((Object)new GridData(1808));
        Menu bar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(bar);
        MenuItem menuFile = new MenuItem(bar, 64);
        menuFile.setText("File");
        Menu fileSubmenu = new Menu((Decorations)shell, 4);
        menuFile.setMenu(fileSubmenu);
        this.menuOpenJADFile = new MenuItem(fileSubmenu, 8);
        this.menuOpenJADFile.setText("Open JAD File...");
        this.menuOpenJADFile.addListener(13, this.menuOpenJADFileListener);
        this.menuOpenJADURL = new MenuItem(fileSubmenu, 0);
        this.menuOpenJADURL.setText("Open JAD URL...");
        this.menuOpenJADURL.addListener(13, this.menuOpenJADURLListener);
        new MenuItem(fileSubmenu, 2);
        MenuItem menuExit = new MenuItem(fileSubmenu, 8);
        menuExit.setText("Exit");
        menuExit.addListener(13, this.menuExitListener);
        MenuItem menuOptions = new MenuItem(bar, 64);
        menuOptions.setText("Options");
        Menu optionsSubmenu = new Menu((Decorations)shell, 4);
        menuOptions.setMenu(optionsSubmenu);
        this.menuSelectDevice = new MenuItem(optionsSubmenu, 8);
        this.menuSelectDevice.setText("Select device...");
        this.menuSelectDevice.addListener(13, this.menuSelectDeviceListener);
        shell.setText("AVACSEmulator");
        devicePanel = new SwtDeviceComponent((Composite)shell);
        devicePanel.setLayoutData(new GridData(1808));
        this.statusBar = new Label((Composite)shell, 256);
        this.statusBar.setText("Status");
        this.statusBar.setLayoutData((Object)new GridData(768));
    }

    public void setDevice(DeviceEntry entry) {
        DeviceFactory.getDevice();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (entry.getFileName() != null) {
                URL[] urls = new URL[]{new File(Config.getConfigPath(), entry.getFileName()).toURI().toURL()};
                classLoader = Common.createExtensionsClassLoader(urls);
            }
            this.emulatorContext.getDeviceFontManager().init();
            DeviceImpl device = DeviceImpl.create(this.emulatorContext, classLoader, entry.getDescriptorLocation(), SwtDevice.class);
            this.deviceEntry = entry;
            this.setDevice(device);
            this.updateDevice();
        }
        catch (MalformedURLException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    protected void updateDevice() {
        shell.setSize(shell.computeSize(-1, -1, true));
    }

    public static void main(String[] args) {
        String midletString;
        Display display = new Display();
        shell = new Shell(display, 224);
        ArrayList<String> params = new ArrayList<String>();
        int i2 = 0;
        while (i2 < args.length) {
            params.add(args[i2]);
            ++i2;
        }
        Swt app = new Swt(shell);
        app.initParams(params, app.selectDeviceDialog.getSelectedDeviceEntry(), SwtDevice.class);
        app.updateDevice();
        shell.pack();
        shell.open();
        try {
            midletString = (String)params.iterator().next();
        }
        catch (NoSuchElementException ex) {
            midletString = null;
        }
        app.initMIDlet(false);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

