/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.capture;

public class NeuQuant {
    protected static final int netsize = 256;
    protected static final int prime1 = 499;
    protected static final int prime2 = 491;
    protected static final int prime3 = 487;
    protected static final int prime4 = 503;
    protected static final int minpicturebytes = 1509;
    protected static final int maxnetpos = 255;
    protected static final int netbiasshift = 4;
    protected static final int ncycles = 100;
    protected static final int intbiasshift = 16;
    protected static final int intbias = 65536;
    protected static final int gammashift = 10;
    protected static final int gamma = 1024;
    protected static final int betashift = 10;
    protected static final int beta = 64;
    protected static final int betagamma = 65536;
    protected static final int initrad = 32;
    protected static final int radiusbiasshift = 6;
    protected static final int radiusbias = 64;
    protected static final int initradius = 2048;
    protected static final int radiusdec = 30;
    protected static final int alphabiasshift = 10;
    protected static final int initalpha = 1024;
    protected int alphadec;
    protected static final int radbiasshift = 8;
    protected static final int radbias = 256;
    protected static final int alpharadbshift = 18;
    protected static final int alpharadbias = 262144;
    protected byte[] thepicture;
    protected int lengthcount;
    protected int samplefac;
    protected int[][] network;
    protected int[] netindex = new int[256];
    protected int[] bias = new int[256];
    protected int[] freq = new int[256];
    protected int[] radpower = new int[32];

    public NeuQuant(byte[] thepic, int len, int sample) {
        this.thepicture = thepic;
        this.lengthcount = len;
        this.samplefac = sample;
        this.network = new int[256][];
        int i2 = 0;
        while (i2 < 256) {
            this.network[i2] = new int[4];
            int[] p2 = this.network[i2];
            p2[1] = p2[2] = (i2 << 12) / 256;
            p2[0] = p2[2];
            this.freq[i2] = 256;
            this.bias[i2] = 0;
            ++i2;
        }
    }

    public byte[] colorMap() {
        byte[] map = new byte[768];
        int[] index = new int[256];
        int i2 = 0;
        while (i2 < 256) {
            index[this.network[i2][3]] = i2;
            ++i2;
        }
        int k2 = 0;
        int i3 = 0;
        while (i3 < 256) {
            int j2 = index[i3];
            map[k2++] = (byte)this.network[j2][0];
            map[k2++] = (byte)this.network[j2][1];
            map[k2++] = (byte)this.network[j2][2];
            ++i3;
        }
        return map;
    }

    public void inxbuild() {
        int j2;
        int previouscol = 0;
        int startpos = 0;
        int i2 = 0;
        while (i2 < 256) {
            int[] q2;
            int[] p2 = this.network[i2];
            int smallpos = i2;
            int smallval = p2[1];
            j2 = i2 + 1;
            while (j2 < 256) {
                q2 = this.network[j2];
                if (q2[1] < smallval) {
                    smallpos = j2;
                    smallval = q2[1];
                }
                ++j2;
            }
            q2 = this.network[smallpos];
            if (i2 != smallpos) {
                j2 = q2[0];
                q2[0] = p2[0];
                p2[0] = j2;
                j2 = q2[1];
                q2[1] = p2[1];
                p2[1] = j2;
                j2 = q2[2];
                q2[2] = p2[2];
                p2[2] = j2;
                j2 = q2[3];
                q2[3] = p2[3];
                p2[3] = j2;
            }
            if (smallval != previouscol) {
                this.netindex[previouscol] = startpos + i2 >> 1;
                j2 = previouscol + 1;
                while (j2 < smallval) {
                    this.netindex[j2] = i2;
                    ++j2;
                }
                previouscol = smallval;
                startpos = i2;
            }
            ++i2;
        }
        this.netindex[previouscol] = startpos + 255 >> 1;
        j2 = previouscol + 1;
        while (j2 < 256) {
            this.netindex[j2] = 255;
            ++j2;
        }
    }

    public void learn() {
        if (this.lengthcount < 1509) {
            this.samplefac = 1;
        }
        this.alphadec = 30 + (this.samplefac - 1) / 3;
        byte[] p2 = this.thepicture;
        int pix = 0;
        int lim = this.lengthcount;
        int samplepixels = this.lengthcount / (3 * this.samplefac);
        int delta = samplepixels / 100;
        int alpha = 1024;
        int radius = 2048;
        int rad = radius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        int i2 = 0;
        while (i2 < rad) {
            this.radpower[i2] = alpha * ((rad * rad - i2 * i2) * 256 / (rad * rad));
            ++i2;
        }
        int step = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
        i2 = 0;
        while (i2 < samplepixels) {
            int b2 = (p2[pix + 0] & 0xFF) << 4;
            int g2 = (p2[pix + 1] & 0xFF) << 4;
            int r2 = (p2[pix + 2] & 0xFF) << 4;
            int j2 = this.contest(b2, g2, r2);
            this.altersingle(alpha, j2, b2, g2, r2);
            if (rad != 0) {
                this.alterneigh(rad, j2, b2, g2, r2);
            }
            if ((pix += step) >= lim) {
                pix -= this.lengthcount;
            }
            ++i2;
            if (delta == 0) {
                delta = 1;
            }
            if (i2 % delta != 0) continue;
            alpha -= alpha / this.alphadec;
            if ((rad = (radius -= radius / 30) >> 6) <= 1) {
                rad = 0;
            }
            j2 = 0;
            while (j2 < rad) {
                this.radpower[j2] = alpha * ((rad * rad - j2 * j2) * 256 / (rad * rad));
                ++j2;
            }
        }
    }

    public int map(int b2, int g2, int r2) {
        int bestd = 1000;
        int best = -1;
        int i2 = this.netindex[g2];
        int j2 = i2 - 1;
        while (i2 < 256 || j2 >= 0) {
            int a2;
            int dist;
            int[] p2;
            if (i2 < 256) {
                p2 = this.network[i2];
                dist = p2[1] - g2;
                if (dist >= bestd) {
                    i2 = 256;
                } else {
                    ++i2;
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a2 = p2[0] - b2) < 0) {
                        a2 = -a2;
                    }
                    if ((dist += a2) < bestd) {
                        a2 = p2[2] - r2;
                        if (a2 < 0) {
                            a2 = -a2;
                        }
                        if ((dist += a2) < bestd) {
                            bestd = dist;
                            best = p2[3];
                        }
                    }
                }
            }
            if (j2 < 0) continue;
            p2 = this.network[j2];
            dist = g2 - p2[1];
            if (dist >= bestd) {
                j2 = -1;
                continue;
            }
            --j2;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a2 = p2[0] - b2) < 0) {
                a2 = -a2;
            }
            if ((dist += a2) >= bestd) continue;
            a2 = p2[2] - r2;
            if (a2 < 0) {
                a2 = -a2;
            }
            if ((dist += a2) >= bestd) continue;
            bestd = dist;
            best = p2[3];
        }
        return best;
    }

    public byte[] process() {
        this.learn();
        this.unbiasnet();
        this.inxbuild();
        return this.colorMap();
    }

    public void unbiasnet() {
        int i2 = 0;
        while (i2 < 256) {
            int[] nArray = this.network[i2];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[i2];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[i2];
            nArray3[2] = nArray3[2] >> 4;
            this.network[i2][3] = i2;
            ++i2;
        }
    }

    protected void alterneigh(int rad, int i2, int b2, int g2, int r2) {
        int hi;
        int lo = i2 - rad;
        if (lo < -1) {
            lo = -1;
        }
        if ((hi = i2 + rad) > 256) {
            hi = 256;
        }
        int j2 = i2 + 1;
        int k2 = i2 - 1;
        int m2 = 1;
        while (j2 < hi || k2 > lo) {
            int[] p2;
            int a2 = this.radpower[m2++];
            if (j2 < hi) {
                p2 = this.network[j2++];
                try {
                    p2[0] = p2[0] - a2 * (p2[0] - b2) / 262144;
                    p2[1] = p2[1] - a2 * (p2[1] - g2) / 262144;
                    p2[2] = p2[2] - a2 * (p2[2] - r2) / 262144;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (k2 <= lo) continue;
            p2 = this.network[k2--];
            try {
                p2[0] = p2[0] - a2 * (p2[0] - b2) / 262144;
                p2[1] = p2[1] - a2 * (p2[1] - g2) / 262144;
                p2[2] = p2[2] - a2 * (p2[2] - r2) / 262144;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void altersingle(int alpha, int i2, int b2, int g2, int r2) {
        int[] n2 = this.network[i2];
        n2[0] = n2[0] - alpha * (n2[0] - b2) / 1024;
        n2[1] = n2[1] - alpha * (n2[1] - g2) / 1024;
        n2[2] = n2[2] - alpha * (n2[2] - r2) / 1024;
    }

    protected int contest(int b2, int g2, int r2) {
        int bestpos;
        int bestd;
        int bestbiasd = bestd = Integer.MAX_VALUE;
        int bestbiaspos = bestpos = -1;
        int i2 = 0;
        while (i2 < 256) {
            int biasdist;
            int a2;
            int[] n2 = this.network[i2];
            int dist = n2[0] - b2;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a2 = n2[1] - g2) < 0) {
                a2 = -a2;
            }
            dist += a2;
            a2 = n2[2] - r2;
            if (a2 < 0) {
                a2 = -a2;
            }
            if ((dist += a2) < bestd) {
                bestd = dist;
                bestpos = i2;
            }
            if ((biasdist = dist - (this.bias[i2] >> 12)) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i2;
            }
            int betafreq = this.freq[i2] >> 10;
            int n3 = i2;
            this.freq[n3] = this.freq[n3] - betafreq;
            int n4 = i2++;
            this.bias[n4] = this.bias[n4] + (betafreq << 10);
        }
        int n5 = bestpos;
        this.freq[n5] = this.freq[n5] + 64;
        int n6 = bestpos;
        this.bias[n6] = this.bias[n6] - 65536;
        return bestbiaspos;
    }
}

