/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Enumeration;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Screen;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.microemu.DisplayAccess;
import org.microemu.DisplayComponent;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.Common;
import org.microemu.app.ui.DisplayRepaintListener;
import org.microemu.app.ui.swing.SwingDeviceComponent;
import org.microemu.device.Device;
import org.microemu.device.DeviceDisplay;
import org.microemu.device.DeviceFactory;
import org.microemu.device.MutableImage;
import org.microemu.device.impl.ButtonName;
import org.microemu.device.impl.InputMethodImpl;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.impl.ui.CommandManager;
import org.microemu.device.j2se.J2SEButton;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEInputMethod;
import org.microemu.device.j2se.J2SEMutableImage;

public class SwingDisplayComponent
extends JComponent
implements DisplayComponent {
    private static final long serialVersionUID = 1L;
    private SwingDeviceComponent deviceComponent;
    private J2SEMutableImage displayImage = null;
    private Graphics displayGraphics;
    private SoftButton initialPressedSoftButton;
    private DisplayRepaintListener displayRepaintListener;
    private boolean showMouseCoordinates = false;
    private Point pressedPoint = new Point();
    private MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e2) {
            SwingDisplayComponent.this.deviceComponent.requestFocus();
            SwingDisplayComponent.this.pressedPoint = e2.getPoint();
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(e2)) {
                KeyEvent event = new KeyEvent(SwingDisplayComponent.this.deviceComponent, 0, System.currentTimeMillis(), 0, 10, '\uffff');
                SwingDisplayComponent.this.deviceComponent.keyPressed(event);
                SwingDisplayComponent.this.deviceComponent.keyReleased(event);
                return;
            }
            Device device = DeviceFactory.getDevice();
            J2SEInputMethod inputMethod = (J2SEInputMethod)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (device.hasPointerEvents()) {
                if (!fullScreenMode) {
                    for (SoftButton button : device.getSoftButtons()) {
                        Rectangle pb;
                        if (!button.isVisible() || (pb = button.getPaintable()) == null || !pb.contains(e2.getX(), e2.getY())) continue;
                        SwingDisplayComponent.this.initialPressedSoftButton = button;
                        button.setPressed(true);
                        SwingDisplayComponent.this.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                        break;
                    }
                }
                Point p2 = SwingDisplayComponent.this.deviceCoordinate(device.getDeviceDisplay(), e2.getPoint());
                inputMethod.pointerPressed(p2.x, p2.y);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            Device device = DeviceFactory.getDevice();
            J2SEInputMethod inputMethod = (J2SEInputMethod)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (device.hasPointerEvents()) {
                if (!fullScreenMode) {
                    if (SwingDisplayComponent.this.initialPressedSoftButton != null && SwingDisplayComponent.this.initialPressedSoftButton.isPressed()) {
                        SwingDisplayComponent.this.initialPressedSoftButton.setPressed(false);
                        Rectangle pb = SwingDisplayComponent.this.initialPressedSoftButton.getPaintable();
                        if (pb != null) {
                            SwingDisplayComponent.this.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                            if (pb.contains(e2.getX(), e2.getY())) {
                                MIDletAccess ma = MIDletBridge.getMIDletAccess();
                                if (ma == null) {
                                    return;
                                }
                                DisplayAccess da = ma.getDisplayAccess();
                                if (da == null) {
                                    return;
                                }
                                Displayable d2 = da.getCurrent();
                                Command cmd = SwingDisplayComponent.this.initialPressedSoftButton.getCommand();
                                if (cmd != null) {
                                    if (cmd.equals(CommandManager.CMD_MENU)) {
                                        CommandManager.getInstance().commandAction(cmd);
                                    } else {
                                        da.commandAction(cmd, d2);
                                    }
                                } else if (d2 != null && d2 instanceof Screen) {
                                    if (SwingDisplayComponent.this.initialPressedSoftButton.getName().equals("up")) {
                                        da.keyPressed(SwingDisplayComponent.this.getButtonByButtonName(ButtonName.UP).getKeyCode());
                                    } else if (SwingDisplayComponent.this.initialPressedSoftButton.getName().equals("down")) {
                                        da.keyPressed(SwingDisplayComponent.this.getButtonByButtonName(ButtonName.DOWN).getKeyCode());
                                    }
                                }
                            }
                        }
                    }
                    SwingDisplayComponent.this.initialPressedSoftButton = null;
                }
                Point p2 = SwingDisplayComponent.this.deviceCoordinate(device.getDeviceDisplay(), e2.getPoint());
                inputMethod.pointerReleased(p2.x, p2.y);
            }
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e2) {
            Point p2;
            if (SwingDisplayComponent.this.showMouseCoordinates) {
                StringBuffer buf = new StringBuffer();
                int width = e2.getX() - ((SwingDisplayComponent)SwingDisplayComponent.this).pressedPoint.x;
                int height = e2.getY() - ((SwingDisplayComponent)SwingDisplayComponent.this).pressedPoint.y;
                p2 = SwingDisplayComponent.this.deviceCoordinate(DeviceFactory.getDevice().getDeviceDisplay(), SwingDisplayComponent.this.pressedPoint);
                buf.append(p2.x).append(",").append(p2.y).append(" ").append(width).append("x").append(height);
                Common.setStatusBar(buf.toString());
            }
            Device device = DeviceFactory.getDevice();
            InputMethodImpl inputMethod = (InputMethodImpl)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (device.hasPointerMotionEvents()) {
                Rectangle pb;
                if (!fullScreenMode && SwingDisplayComponent.this.initialPressedSoftButton != null && (pb = SwingDisplayComponent.this.initialPressedSoftButton.getPaintable()) != null) {
                    if (pb.contains(e2.getX(), e2.getY())) {
                        if (!SwingDisplayComponent.this.initialPressedSoftButton.isPressed()) {
                            SwingDisplayComponent.this.initialPressedSoftButton.setPressed(true);
                            SwingDisplayComponent.this.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                        }
                    } else if (SwingDisplayComponent.this.initialPressedSoftButton.isPressed()) {
                        SwingDisplayComponent.this.initialPressedSoftButton.setPressed(false);
                        SwingDisplayComponent.this.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                    }
                }
                p2 = SwingDisplayComponent.this.deviceCoordinate(device.getDeviceDisplay(), e2.getPoint());
                inputMethod.pointerDragged(p2.x, p2.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (SwingDisplayComponent.this.showMouseCoordinates) {
                StringBuffer buf = new StringBuffer();
                Point p2 = SwingDisplayComponent.this.deviceCoordinate(DeviceFactory.getDevice().getDeviceDisplay(), e2.getPoint());
                buf.append(p2.x).append(",").append(p2.y);
                Common.setStatusBar(buf.toString());
            }
        }
    };
    private MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent ev) {
            if (ev.getWheelRotation() > 0) {
                KeyEvent event = new KeyEvent(SwingDisplayComponent.this.deviceComponent, 0, System.currentTimeMillis(), 0, 40, '\uffff');
                SwingDisplayComponent.this.deviceComponent.keyPressed(event);
                SwingDisplayComponent.this.deviceComponent.keyReleased(event);
            } else {
                KeyEvent event = new KeyEvent(SwingDisplayComponent.this.deviceComponent, 0, System.currentTimeMillis(), 0, 38, '\uffff');
                SwingDisplayComponent.this.deviceComponent.keyPressed(event);
                SwingDisplayComponent.this.deviceComponent.keyReleased(event);
            }
        }
    };

    SwingDisplayComponent(SwingDeviceComponent deviceComponent) {
        this.deviceComponent = deviceComponent;
        this.setFocusable(false);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
        this.addMouseWheelListener(this.mouseWheelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        SwingDisplayComponent swingDisplayComponent = this;
        synchronized (swingDisplayComponent) {
            this.displayImage = null;
            this.initialPressedSoftButton = null;
        }
    }

    @Override
    public void addDisplayRepaintListener(DisplayRepaintListener l2) {
        this.displayRepaintListener = l2;
    }

    @Override
    public void removeDisplayRepaintListener(DisplayRepaintListener l2) {
        if (this.displayRepaintListener == l2) {
            this.displayRepaintListener = null;
        }
    }

    @Override
    public MutableImage getDisplayImage() {
        return this.displayImage;
    }

    @Override
    public Dimension getPreferredSize() {
        Device device = DeviceFactory.getDevice();
        if (device == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(device.getDeviceDisplay().getFullWidth(), device.getDeviceDisplay().getFullHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g2) {
        if (this.displayImage != null) {
            J2SEMutableImage j2SEMutableImage = this.displayImage;
            synchronized (j2SEMutableImage) {
                g2.drawImage(this.displayImage.getImage(), 0, 0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaintRequest(int x2, int y2, int width, int height) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        Displayable current = da.getCurrent();
        if (current == null) {
            return;
        }
        Device device = DeviceFactory.getDevice();
        if (device != null) {
            J2SEDeviceDisplay deviceDisplay = (J2SEDeviceDisplay)device.getDeviceDisplay();
            SwingDisplayComponent swingDisplayComponent = this;
            synchronized (swingDisplayComponent) {
                if (this.displayImage == null) {
                    this.displayImage = new J2SEMutableImage(device.getDeviceDisplay().getFullWidth(), device.getDeviceDisplay().getFullHeight());
                    this.displayGraphics = this.displayImage.getImage().getGraphics();
                }
                J2SEMutableImage j2SEMutableImage = this.displayImage;
                synchronized (j2SEMutableImage) {
                    deviceDisplay.paintDisplayable(this.displayGraphics, x2, y2, width, height);
                    if (!deviceDisplay.isFullScreenMode()) {
                        deviceDisplay.paintControls(this.displayGraphics);
                    }
                }
                this.fireDisplayRepaint(this.displayImage);
            }
            if (deviceDisplay.isFullScreenMode()) {
                this.repaint(x2, y2, width, height);
            } else {
                this.repaint(0, 0, this.displayImage.getWidth(), this.displayImage.getHeight());
            }
        }
    }

    private void fireDisplayRepaint(MutableImage image) {
        if (this.displayRepaintListener != null) {
            this.displayRepaintListener.repaintInvoked(image);
        }
    }

    Point deviceCoordinate(DeviceDisplay deviceDisplay, Point p2) {
        if (deviceDisplay.isFullScreenMode()) {
            return p2;
        }
        Rectangle pb = ((J2SEDeviceDisplay)deviceDisplay).getDisplayPaintable();
        return new Point(p2.x - pb.x, p2.y - pb.y);
    }

    void switchShowMouseCoordinates() {
        this.showMouseCoordinates = !this.showMouseCoordinates;
    }

    public MutableImage getScaledDisplayImage(int zoom) {
        return this.displayImage.scale(zoom);
    }

    public MouseAdapter getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public MouseWheelListener getMouseWheelListener() {
        return this.mouseWheelListener;
    }

    private J2SEButton getButtonByButtonName(ButtonName buttonName) {
        Enumeration e2 = DeviceFactory.getDevice().getButtons().elements();
        while (e2.hasMoreElements()) {
            J2SEButton result = (J2SEButton)e2.nextElement();
            if (result.getFunctionalName() != buttonName) continue;
            return result;
        }
        return null;
    }
}

