/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.microemu.DisplayAccess;
import org.microemu.DisplayComponent;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.swt.ImageFilter;
import org.microemu.app.ui.swt.SwtDisplayComponent;
import org.microemu.app.ui.swt.SwtGraphics;
import org.microemu.device.DeviceFactory;
import org.microemu.device.impl.Polygon;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.Shape;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.impl.ui.CommandManager;
import org.microemu.device.swt.SwtButton;
import org.microemu.device.swt.SwtDeviceDisplay;
import org.microemu.device.swt.SwtImmutableImage;
import org.microemu.device.swt.SwtInputMethod;

public class SwtDeviceComponent
extends Canvas {
    private static SwtDeviceComponent instance;
    private static HashMap colors;
    private SwtDisplayComponent dc;
    private org.eclipse.swt.graphics.Image fBuffer = null;
    private SwtButton prevOverButton;
    private SwtButton overButton;
    private SwtButton pressedButton;
    private SoftButton initialPressedSoftButton;
    private boolean mousePressed;
    KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent ev) {
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            org.microemu.device.Device device = DeviceFactory.getDevice();
            for (SwtButton button : device.getButtons()) {
                if (ev.keyCode != button.getKeyboardKey()) continue;
                ev.keyCode = button.getKeyCode();
                break;
            }
            ((SwtInputMethod)device.getInputMethod()).keyPressed(ev);
            SwtDeviceComponent.this.pressedButton = ((SwtInputMethod)device.getInputMethod()).getButton(ev);
            if (SwtDeviceComponent.this.pressedButton != null) {
                Shape shape = SwtDeviceComponent.this.pressedButton.getShape();
                if (shape != null) {
                    Rectangle r2 = shape.getBounds();
                    SwtDeviceComponent.this.redraw(r2.x, r2.y, r2.width, r2.height, true);
                }
            } else {
                SwtDeviceComponent.this.redraw();
            }
        }

        public void keyReleased(KeyEvent ev) {
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            org.microemu.device.Device device = DeviceFactory.getDevice();
            for (SwtButton button : device.getButtons()) {
                if (ev.keyCode != button.getKeyboardKey()) continue;
                ev.keyCode = button.getKeyCode();
                break;
            }
            ((SwtInputMethod)device.getInputMethod()).keyReleased(ev);
            SwtDeviceComponent.this.prevOverButton = SwtDeviceComponent.this.pressedButton;
            SwtDeviceComponent.this.pressedButton = null;
            if (SwtDeviceComponent.this.prevOverButton != null) {
                Shape shape = SwtDeviceComponent.this.prevOverButton.getShape();
                if (shape != null) {
                    Rectangle r2 = shape.getBounds();
                    SwtDeviceComponent.this.redraw(r2.x, r2.y, r2.width, r2.height, true);
                }
            } else {
                SwtDeviceComponent.this.redraw();
            }
        }
    };
    MouseAdapter mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e2) {
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            org.microemu.device.Device device = DeviceFactory.getDevice();
            Rectangle rect = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
            SwtInputMethod inputMethod = (SwtInputMethod)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (rect.x <= e2.x && rect.x + rect.width > e2.x && rect.y <= e2.y && rect.y + rect.height > e2.y) {
                if (device.hasPointerEvents()) {
                    if (!fullScreenMode) {
                        for (SoftButton button : device.getSoftButtons()) {
                            Rectangle pb;
                            if (!button.isVisible() || (pb = button.getPaintable()) == null || !pb.contains(e2.x - rect.x, e2.y - rect.y)) continue;
                            SwtDeviceComponent.this.initialPressedSoftButton = button;
                            button.setPressed(true);
                            SwtDeviceComponent.this.dc.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                            break;
                        }
                    }
                    if (fullScreenMode) {
                        inputMethod.pointerPressed(e2.x - rect.x, e2.y - rect.y);
                    } else {
                        Rectangle pb = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayPaintable();
                        inputMethod.pointerPressed(e2.x - rect.x - pb.x, e2.y - rect.y - pb.y);
                    }
                }
            } else {
                SwtDeviceComponent.this.pressedButton = SwtDeviceComponent.this.getButton(e2.x, e2.y);
                if (SwtDeviceComponent.this.pressedButton != null) {
                    if (SwtDeviceComponent.this.pressedButton instanceof SoftButton && !fullScreenMode) {
                        Command cmd = ((SoftButton)((Object)SwtDeviceComponent.this.pressedButton)).getCommand();
                        if (cmd != null) {
                            MIDletAccess ma = MIDletBridge.getMIDletAccess();
                            if (ma == null) {
                                return;
                            }
                            DisplayAccess da = ma.getDisplayAccess();
                            if (da == null) {
                                return;
                            }
                            if (cmd.equals(CommandManager.CMD_MENU)) {
                                CommandManager.getInstance().commandAction(cmd);
                            } else {
                                da.commandAction(cmd, da.getCurrent());
                            }
                        }
                    } else {
                        Event event = new Event();
                        event.widget = e2.widget;
                        KeyEvent ev = new KeyEvent(event);
                        ev.keyCode = SwtDeviceComponent.this.pressedButton.getKeyCode();
                        inputMethod.mousePressed(ev);
                    }
                    Rectangle r2 = SwtDeviceComponent.this.pressedButton.getShape().getBounds();
                    SwtDeviceComponent.this.redraw(r2.x, r2.y, r2.width, r2.height, true);
                }
            }
            SwtDeviceComponent.this.mousePressed = true;
        }

        public void mouseUp(MouseEvent e2) {
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            org.microemu.device.Device device = DeviceFactory.getDevice();
            Rectangle rect = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
            SwtInputMethod inputMethod = (SwtInputMethod)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (rect.x <= e2.x && rect.x + rect.width > e2.x && rect.y <= e2.y && rect.y + rect.height > e2.y) {
                if (device.hasPointerEvents()) {
                    Rectangle pb;
                    if (!fullScreenMode) {
                        if (SwtDeviceComponent.this.initialPressedSoftButton != null && SwtDeviceComponent.this.initialPressedSoftButton.isPressed()) {
                            SwtDeviceComponent.this.initialPressedSoftButton.setPressed(false);
                            pb = SwtDeviceComponent.this.initialPressedSoftButton.getPaintable();
                            if (pb != null) {
                                Command cmd;
                                SwtDeviceComponent.this.dc.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                                if (pb.contains(e2.x - rect.x, e2.y - rect.y) && (cmd = SwtDeviceComponent.this.initialPressedSoftButton.getCommand()) != null) {
                                    MIDletAccess ma = MIDletBridge.getMIDletAccess();
                                    if (ma == null) {
                                        return;
                                    }
                                    DisplayAccess da = ma.getDisplayAccess();
                                    if (da == null) {
                                        return;
                                    }
                                    if (cmd.equals(CommandManager.CMD_MENU)) {
                                        CommandManager.getInstance().commandAction(cmd);
                                    } else {
                                        da.commandAction(cmd, da.getCurrent());
                                    }
                                }
                            }
                        }
                        SwtDeviceComponent.this.initialPressedSoftButton = null;
                    }
                    if (fullScreenMode) {
                        inputMethod.pointerReleased(e2.x - rect.x, e2.y - rect.y);
                    } else {
                        pb = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayPaintable();
                        inputMethod.pointerReleased(e2.x - rect.x - pb.x, e2.y - rect.y - pb.y);
                    }
                }
            } else {
                SwtButton prevOverButton = SwtDeviceComponent.this.getButton(e2.x, e2.y);
                if (prevOverButton != null) {
                    inputMethod.mouseReleased(prevOverButton.getKeyCode());
                }
                SwtDeviceComponent.this.pressedButton = null;
                if (prevOverButton != null) {
                    Rectangle r2 = prevOverButton.getShape().getBounds();
                    SwtDeviceComponent.this.redraw(r2.x, r2.y, r2.width, r2.height, true);
                } else {
                    SwtDeviceComponent.this.redraw();
                }
            }
            SwtDeviceComponent.this.mousePressed = false;
        }
    };
    MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e2) {
            SwtDeviceComponent.this.prevOverButton = SwtDeviceComponent.this.overButton;
            SwtDeviceComponent.this.overButton = SwtDeviceComponent.this.getButton(e2.x, e2.y);
            if (SwtDeviceComponent.this.overButton != SwtDeviceComponent.this.prevOverButton) {
                Rectangle r2;
                if (SwtDeviceComponent.this.prevOverButton != null) {
                    r2 = SwtDeviceComponent.this.prevOverButton.getShape().getBounds();
                    SwtDeviceComponent.this.redraw(r2.x, r2.y, r2.width, r2.height, true);
                }
                if (SwtDeviceComponent.this.overButton != null) {
                    r2 = SwtDeviceComponent.this.overButton.getShape().getBounds();
                    SwtDeviceComponent.this.redraw(r2.x, r2.y, r2.width, r2.height, true);
                }
            }
            if (SwtDeviceComponent.this.mousePressed) {
                org.microemu.device.Device device = DeviceFactory.getDevice();
                Rectangle rect = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
                SwtInputMethod inputMethod = (SwtInputMethod)device.getInputMethod();
                boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
                if (rect.x <= e2.x && rect.x + rect.width > e2.x && rect.y <= e2.y && rect.y + rect.height > e2.y && device.hasPointerMotionEvents()) {
                    Rectangle pb;
                    if (!fullScreenMode && SwtDeviceComponent.this.initialPressedSoftButton != null && (pb = SwtDeviceComponent.this.initialPressedSoftButton.getPaintable()) != null) {
                        if (pb.contains(e2.x - rect.x, e2.y - rect.y)) {
                            if (!SwtDeviceComponent.this.initialPressedSoftButton.isPressed()) {
                                SwtDeviceComponent.this.initialPressedSoftButton.setPressed(true);
                                SwtDeviceComponent.this.dc.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                            }
                        } else if (SwtDeviceComponent.this.initialPressedSoftButton.isPressed()) {
                            SwtDeviceComponent.this.initialPressedSoftButton.setPressed(false);
                            SwtDeviceComponent.this.dc.repaintRequest(pb.x, pb.y, pb.width, pb.height);
                        }
                    }
                    if (fullScreenMode) {
                        inputMethod.pointerDragged(e2.x - rect.x, e2.y - rect.y);
                    } else {
                        pb = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayPaintable();
                        inputMethod.pointerDragged(e2.x - rect.x - pb.x, e2.y - rect.y - pb.y);
                    }
                }
            }
        }
    };

    static {
        colors = new HashMap();
    }

    public SwtDeviceComponent(Composite parent) {
        super(parent, 262144);
        instance = this;
        this.mousePressed = false;
        this.dc = new SwtDisplayComponent(this);
        this.initialPressedSoftButton = null;
        this.addKeyListener(this.keyListener);
        this.addMouseListener((MouseListener)this.mouseListener);
        this.addMouseMoveListener(this.mouseMoveListener);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e2) {
                SwtDeviceComponent.this.paintControl(e2);
            }
        });
    }

    public DisplayComponent getDisplayComponent() {
        return this.dc;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Image tmp = DeviceFactory.getDevice().getNormalImage();
        return new Point(tmp.getWidth(), tmp.getHeight());
    }

    public void paintControl(PaintEvent pe) {
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            org.eclipse.swt.graphics.Rectangle r2 = this.fBuffer.getBounds();
            if (r2.width != size.x || r2.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new org.eclipse.swt.graphics.Image((Device)this.getDisplay(), size.x, size.y);
        }
        SwtGraphics gc = new SwtGraphics(new GC((Drawable)this.fBuffer));
        try {
            Rectangle rect;
            Shape shape;
            org.microemu.device.Device device = DeviceFactory.getDevice();
            gc.drawImage(((SwtImmutableImage)device.getNormalImage()).getImage(), 0, 0);
            Rectangle displayRectangle = ((SwtDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
            gc.translate(displayRectangle.x, displayRectangle.y);
            this.dc.paint(gc);
            gc.translate(-displayRectangle.x, -displayRectangle.y);
            if (this.prevOverButton != null) {
                shape = this.prevOverButton.getShape();
                if (shape != null) {
                    this.drawImageInShape(gc, ((SwtImmutableImage)device.getNormalImage()).getImage(), shape);
                }
                this.prevOverButton = null;
            }
            if (this.overButton != null && (shape = this.overButton.getShape()) != null) {
                this.drawImageInShape(gc, ((SwtImmutableImage)device.getOverImage()).getImage(), shape);
            }
            if (this.pressedButton != null && (shape = this.pressedButton.getShape()) != null) {
                this.drawImageInShape(gc, ((SwtImmutableImage)device.getPressedImage()).getImage(), shape);
            }
            if (this.prevOverButton != null) {
                rect = this.prevOverButton.getShape().getBounds();
                if (rect != null) {
                    gc.drawImage(((SwtImmutableImage)DeviceFactory.getDevice().getNormalImage()).getImage(), rect.x, rect.y, rect.width, rect.height, rect.x, rect.y, rect.width, rect.height);
                }
                this.prevOverButton = null;
            }
            if (this.overButton != null && (rect = this.overButton.getShape().getBounds()) != null) {
                gc.drawImage(((SwtImmutableImage)DeviceFactory.getDevice().getOverImage()).getImage(), rect.x, rect.y, rect.width, rect.height, rect.x, rect.y, rect.width, rect.height);
            }
            if (this.pressedButton != null && (rect = this.pressedButton.getShape().getBounds()) != null) {
                gc.drawImage(((SwtImmutableImage)DeviceFactory.getDevice().getPressedImage()).getImage(), rect.x, rect.y, rect.width, rect.height, rect.x, rect.y, rect.width, rect.height);
            }
        }
        finally {
            gc.dispose();
        }
        pe.gc.drawImage(this.fBuffer, 0, 0);
    }

    private void drawImageInShape(SwtGraphics g2, org.eclipse.swt.graphics.Image image, Shape shape) {
        org.eclipse.swt.graphics.Rectangle clipSave = g2.getClipping();
        boolean cfr_ignored_0 = shape instanceof Polygon;
        Rectangle r2 = shape.getBounds();
        g2.drawImage(image, r2.x, r2.y, r2.width, r2.height, r2.x, r2.y, r2.width, r2.height);
        g2.setClipping(clipSave);
    }

    private SwtButton getButton(int x2, int y2) {
        Enumeration e2 = DeviceFactory.getDevice().getButtons().elements();
        while (e2.hasMoreElements()) {
            SwtButton button = (SwtButton)e2.nextElement();
            if (button.getShape() == null) continue;
            try {
                Shape tmp = (Shape)button.getShape().clone();
                if (!tmp.contains(x2, y2)) continue;
                return button;
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static org.eclipse.swt.graphics.Image createImage(int width, int height) {
        return new org.eclipse.swt.graphics.Image((Device)instance.getDisplay(), width, height);
    }

    public static org.eclipse.swt.graphics.Image createImage(org.eclipse.swt.graphics.Image image) {
        return new org.eclipse.swt.graphics.Image((Device)instance.getDisplay(), image, 0);
    }

    public static org.eclipse.swt.graphics.Image createImage(ImageData data) {
        SwtDeviceComponent swtDeviceComponent = instance;
        ((Object)((Object)swtDeviceComponent)).getClass();
        CreateImageRunnable createImageRunnable = swtDeviceComponent.new CreateImageRunnable(data);
        instance.getDisplay().syncExec((Runnable)createImageRunnable);
        return createImageRunnable.getImage();
    }

    public static org.eclipse.swt.graphics.Image createImage(InputStream is) {
        ImageData data = new ImageData(is);
        SwtDeviceComponent swtDeviceComponent = instance;
        ((Object)((Object)swtDeviceComponent)).getClass();
        CreateImageRunnable createImageRunnable = swtDeviceComponent.new CreateImageRunnable(data);
        instance.getDisplay().syncExec((Runnable)createImageRunnable);
        return createImageRunnable.getImage();
    }

    public static org.eclipse.swt.graphics.Image createImage(InputStream is, ImageFilter filter) throws IOException {
        try {
            ImageData data = new ImageData(is);
            RGB[] rgbs = data.getRGBs();
            if (rgbs != null) {
                int i2 = 0;
                while (i2 < rgbs.length) {
                    rgbs[i2] = filter.filterRGB(0, 0, rgbs[i2]);
                    ++i2;
                }
            } else {
                int y2 = 0;
                while (y2 < data.height) {
                    int x2 = 0;
                    while (x2 < data.width) {
                        int pixel = data.getPixel(x2, y2);
                        RGB rgb = new RGB(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF);
                        rgb = filter.filterRGB(x2, y2, rgb);
                        data.setPixel(x2, y2, (rgb.red << 16) + (rgb.green << 8) + rgb.blue);
                        ++x2;
                    }
                    ++y2;
                }
            }
            SwtDeviceComponent swtDeviceComponent = instance;
            ((Object)((Object)swtDeviceComponent)).getClass();
            CreateImageRunnable createImageRunnable = swtDeviceComponent.new CreateImageRunnable(data);
            instance.getDisplay().syncExec((Runnable)createImageRunnable);
            return createImageRunnable.getImage();
        }
        catch (SWTException ex) {
            throw new IOException(ex.toString());
        }
    }

    public static Color getColor(RGB rgb) {
        Color result = (Color)colors.get(rgb);
        if (result == null) {
            SwtDeviceComponent swtDeviceComponent = instance;
            ((Object)((Object)swtDeviceComponent)).getClass();
            CreateColorRunnable createColorRunnable = swtDeviceComponent.new CreateColorRunnable(rgb);
            instance.getDisplay().syncExec((Runnable)createColorRunnable);
            result = createColorRunnable.getColor();
            colors.put(rgb, result);
        }
        return result;
    }

    public static Font getFont(String name, int size, int style, boolean antialiasing) {
        SwtDeviceComponent swtDeviceComponent = instance;
        ((Object)((Object)swtDeviceComponent)).getClass();
        GetFontRunnable getFontRunnable = swtDeviceComponent.new GetFontRunnable(name, size, style, antialiasing);
        instance.getDisplay().syncExec((Runnable)getFontRunnable);
        return getFontRunnable.getFont();
    }

    public static FontMetrics getFontMetrics(Font font) {
        SwtDeviceComponent swtDeviceComponent = instance;
        ((Object)((Object)swtDeviceComponent)).getClass();
        GetFontMetricsRunnable getFontMetricsRunnable = swtDeviceComponent.new GetFontMetricsRunnable(font);
        instance.getDisplay().syncExec((Runnable)getFontMetricsRunnable);
        return getFontMetricsRunnable.getFontMetrics();
    }

    public static int stringWidth(Font font, String str) {
        SwtDeviceComponent swtDeviceComponent = instance;
        ((Object)((Object)swtDeviceComponent)).getClass();
        StringWidthRunnable stringWidthRunnable = swtDeviceComponent.new StringWidthRunnable(font, str);
        instance.getDisplay().syncExec((Runnable)stringWidthRunnable);
        return stringWidthRunnable.stringWidth();
    }

    private class CreateColorRunnable
    implements Runnable {
        private RGB rgb;
        private Color color;

        CreateColorRunnable(RGB rgb) {
            this.rgb = rgb;
        }

        Color getColor() {
            return this.color;
        }

        @Override
        public void run() {
            this.color = new Color((Device)instance.getParent().getDisplay(), this.rgb);
        }
    }

    private class CreateImageRunnable
    implements Runnable {
        private ImageData data;
        private org.eclipse.swt.graphics.Image image;

        CreateImageRunnable(ImageData data) {
            this.data = data;
        }

        org.eclipse.swt.graphics.Image getImage() {
            return this.image;
        }

        @Override
        public void run() {
            this.image = new org.eclipse.swt.graphics.Image((Device)instance.getParent().getDisplay(), this.data);
        }
    }

    private class GetFontMetricsRunnable
    implements Runnable {
        private Font font;
        private FontMetrics fontMetrics;

        GetFontMetricsRunnable(Font font) {
            this.font = font;
        }

        FontMetrics getFontMetrics() {
            return this.fontMetrics;
        }

        @Override
        public void run() {
            SwtGraphics gc = new SwtGraphics(instance.getParent().getDisplay());
            gc.setFont(this.font);
            this.fontMetrics = gc.getFontMetrics();
            gc.dispose();
        }
    }

    private class GetFontRunnable
    implements Runnable {
        private String name;
        private int size;
        private int style;
        private boolean antialiasing;
        private Font font;

        GetFontRunnable(String name, int size, int style, boolean antialiasing) {
            this.name = name;
            this.size = size;
            this.style = style;
        }

        Font getFont() {
            return this.font;
        }

        @Override
        public void run() {
            SwtGraphics gc = new SwtGraphics(instance.getParent().getDisplay());
            gc.setAntialias(this.antialiasing);
            gc.setFont(new Font((Device)instance.getParent().getDisplay(), this.name, this.size, this.style));
            this.font = gc.getFont();
            gc.dispose();
        }
    }

    private class StringWidthRunnable
    implements Runnable {
        private Font font;
        private String str;
        private int stringWidth;

        StringWidthRunnable(Font font, String str) {
            this.font = font;
            this.str = str;
        }

        int stringWidth() {
            return this.stringWidth;
        }

        @Override
        public void run() {
            SwtGraphics gc = new SwtGraphics(instance.getParent().getDisplay());
            gc.setFont(this.font);
            this.stringWidth = gc.stringWidth(this.str);
            gc.dispose();
        }
    }
}

