/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swt;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class SwtDialog {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private Shell parentShell;
    private Shell shell;
    protected Control dialogArea;
    protected Control buttonBar;
    protected Button btOk;
    protected Button btCancel;
    private boolean resizeHasOccurred = false;
    private Listener resizeListener;
    private Control contents;
    private int shellStyle = 1264;
    private boolean block = false;
    private int returnCode = 0;

    public SwtDialog(Shell parentShell) {
        this.parentShell = parentShell;
        this.block = true;
        this.shellStyle = 67680;
    }

    public void create() {
        this.shell = this.createShell();
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    protected final Shell createShell() {
        Shell newShell = new Shell(this.parentShell, this.shellStyle);
        this.resizeListener = new Listener(){

            public void handleEvent(Event e2) {
                SwtDialog.this.resizeHasOccurred = true;
            }
        };
        newShell.addListener(11, this.resizeListener);
        newShell.setData((Object)this);
        newShell.addShellListener(this.getShellListener());
        this.configureShell(newShell);
        return newShell;
    }

    protected void configureShell(Shell newShell) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        newShell.setLayout((Layout)layout);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(64));
        composite.setFont(parent.getFont());
        this.btOk = new Button(composite, 8);
        this.btOk.setText("OK");
        this.btOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SwtDialog.this.buttonPressed(0);
            }
        });
        this.btCancel = new Button(composite, 8);
        this.btCancel.setText("Cancel");
        this.btCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SwtDialog.this.buttonPressed(1);
            }
        });
        return composite;
    }

    protected void initializeBounds() {
        if (this.resizeListener != null) {
            this.shell.removeListener(11, this.resizeListener);
        }
        if (this.resizeHasOccurred) {
            return;
        }
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.shell.setBounds(location.x, location.y, size.x, size.y);
    }

    protected Point getInitialSize() {
        return this.shell.computeSize(-1, -1, true);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parentShell = this.shell.getParent();
        Rectangle containerBounds = parentShell != null ? parentShell.getBounds() : this.shell.getDisplay().getClientArea();
        int x2 = Math.max(0, containerBounds.x + (containerBounds.width - initialSize.x) / 2);
        int y2 = Math.max(0, containerBounds.y + (containerBounds.height - initialSize.y) / 3);
        return new Point(x2, y2);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    protected int getReturnCode() {
        return this.returnCode;
    }

    protected void setReturnCode(int code) {
        this.returnCode = code;
    }

    protected ShellListener getShellListener() {
        return new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                SwtDialog.this.setReturnCode(1);
                SwtDialog.this.close();
            }
        };
    }

    public boolean close() {
        if (this.shell != null || !this.shell.isDisposed()) {
            this.shell.dispose();
            this.shell = null;
            this.contents = null;
        }
        this.buttonBar = null;
        this.dialogArea = null;
        return true;
    }

    public Shell getShell() {
        return this.shell;
    }

    public int open() {
        if (this.shell == null) {
            this.create();
        }
        this.shell.open();
        if (this.block) {
            this.runEventLoop(this.shell);
        }
        return this.returnCode;
    }

    private void runEventLoop(Shell shell) {
        Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        while (shell != null && !shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable ex) {
                System.err.println(ex);
            }
        }
        display.update();
    }
}

