/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swt;

import javax.microedition.lcdui.Displayable;
import org.eclipse.swt.widgets.Canvas;
import org.microemu.DisplayAccess;
import org.microemu.DisplayComponent;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.DisplayRepaintListener;
import org.microemu.app.ui.swt.SwtGraphics;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.MutableImage;
import org.microemu.device.swt.SwtDeviceDisplay;
import org.microemu.device.swt.SwtDisplayGraphics;
import org.microemu.device.swt.SwtMutableImage;

public class SwtDisplayComponent
implements DisplayComponent {
    private Canvas deviceCanvas;
    private SwtMutableImage displayImage = null;
    private DisplayRepaintListener displayRepaintListener;
    private Runnable redrawRunnable = new Runnable(){

        @Override
        public void run() {
            if (!SwtDisplayComponent.this.deviceCanvas.isDisposed()) {
                SwtDisplayComponent.this.deviceCanvas.redraw();
            }
        }
    };

    SwtDisplayComponent(Canvas deviceCanvas) {
        this.deviceCanvas = deviceCanvas;
    }

    @Override
    public void addDisplayRepaintListener(DisplayRepaintListener l2) {
        this.displayRepaintListener = l2;
    }

    @Override
    public void removeDisplayRepaintListener(DisplayRepaintListener l2) {
        if (this.displayRepaintListener == l2) {
            this.displayRepaintListener = null;
        }
    }

    @Override
    public MutableImage getDisplayImage() {
        return this.displayImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(SwtGraphics gc) {
        SwtDisplayComponent swtDisplayComponent = this;
        synchronized (swtDisplayComponent) {
            if (this.displayImage != null) {
                gc.drawImage(this.displayImage.img, 0, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaintRequest(int x2, int y2, int width, int height) {
        if (!this.deviceCanvas.isDisposed()) {
            MIDletAccess ma = MIDletBridge.getMIDletAccess();
            if (ma == null) {
                return;
            }
            DisplayAccess da = ma.getDisplayAccess();
            if (da == null) {
                return;
            }
            Displayable current = da.getCurrent();
            if (current == null) {
                return;
            }
            Device device = DeviceFactory.getDevice();
            SwtMutableImage image = new SwtMutableImage(device.getDeviceDisplay().getFullWidth(), device.getDeviceDisplay().getFullHeight());
            SwtGraphics gc = ((SwtDisplayGraphics)image.getGraphics()).g;
            try {
                SwtDeviceDisplay deviceDisplay = (SwtDeviceDisplay)device.getDeviceDisplay();
                deviceDisplay.paintDisplayable(gc, x2, y2, width, height);
                if (!deviceDisplay.isFullScreenMode()) {
                    deviceDisplay.paintControls(gc);
                }
            }
            finally {
                gc.dispose();
            }
            SwtDisplayComponent swtDisplayComponent = this;
            synchronized (swtDisplayComponent) {
                if (this.displayImage != null) {
                    this.displayImage.img.dispose();
                }
                this.displayImage = image;
            }
            this.fireDisplayRepaint(this.displayImage);
            this.deviceCanvas.getDisplay().asyncExec(this.redrawRunnable);
        }
    }

    private void fireDisplayRepaint(MutableImage image) {
        if (this.displayRepaintListener != null) {
            this.displayRepaintListener.repaintInvoked(image);
        }
    }
}

