/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swt;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.microemu.app.ui.swt.SwtDialog;

public class SwtMessageDialog
extends SwtDialog {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int QUESTION = 4;
    private String title;
    private String message;
    private String[] buttonLabels;
    private int defaultIndex;

    public SwtMessageDialog(Shell parentShell, String title, String message, int imageType, String[] buttonLabels, int defaultIndex) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.buttonLabels = buttonLabels;
        this.defaultIndex = defaultIndex;
    }

    public static void openMessageDialog(Shell parent, String title, String message, int messageType) {
        SwtMessageDialog dialog = new SwtMessageDialog(parent, title, message, messageType, new String[]{"OK"}, 0);
        dialog.open();
    }

    public static boolean openQuestion(Shell parent, String title, String message) {
        SwtMessageDialog dialog = new SwtMessageDialog(parent, title, message, 4, new String[]{"Yes", "No"}, 0);
        return dialog.open() == 0;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label lbMessage = new Label(composite, 0);
        lbMessage.setText(this.message);
        lbMessage.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(this.buttonLabels.length, false));
        composite.setLayoutData((Object)new GridData(64));
        composite.setFont(parent.getFont());
        int i2 = 0;
        while (i2 < this.buttonLabels.length) {
            Shell shell;
            Button button = new Button(composite, 8);
            button.setText(this.buttonLabels[i2]);
            button.setData((Object)new Integer(i2));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SwtMessageDialog.this.buttonPressed((Integer)event.widget.getData());
                }
            });
            if (i2 == this.defaultIndex && (shell = parent.getShell()) != null) {
                shell.setDefaultButton(button);
            }
            ++i2;
        }
        return composite;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }
}

