/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swt;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.microemu.EmulatorContext;
import org.microemu.app.Common;
import org.microemu.app.Config;
import org.microemu.app.ui.Message;
import org.microemu.app.ui.swt.SwtDialog;
import org.microemu.app.util.DeviceEntry;
import org.microemu.app.util.IOUtils;
import org.microemu.device.Device;
import org.microemu.device.impl.DeviceImpl;
import org.microemu.device.swt.SwtDevice;

public class SwtSelectDeviceDialog
extends SwtDialog {
    private EmulatorContext emulatorContext;
    private Button btAdd;
    private Button btRemove;
    private Button btDefault;
    private List lsDevices;
    private Vector deviceModel;
    private DeviceEntry selectedEntry;
    private Listener btAddListener = new Listener(){
        private FileDialog fileDialog = null;

        /*
         * WARNING - void declaration
         */
        public void handleEvent(Event event) {
            if (this.fileDialog == null) {
                this.fileDialog = new FileDialog(SwtSelectDeviceDialog.this.getShell(), 4096);
                this.fileDialog.setText("Open device profile file...");
                this.fileDialog.setFilterNames(new String[]{"Device profile (*.jar)"});
                this.fileDialog.setFilterExtensions(new String[]{"*.jar"});
            }
            this.fileDialog.open();
            if (this.fileDialog.getFileName() != null) {
                File file;
                String manifestDeviceName = null;
                URL[] urls = new URL[1];
                ArrayList<String> descriptorEntries = new ArrayList<String>();
                try {
                    file = new File(this.fileDialog.getFilterPath(), this.fileDialog.getFileName());
                    JarFile jar = new JarFile(file);
                    Manifest manifest = jar.getManifest();
                    if (manifest != null) {
                        Attributes attrs = manifest.getMainAttributes();
                        manifestDeviceName = attrs.getValue("Device-Name");
                    }
                    Enumeration<JarEntry> en = jar.entries();
                    while (en.hasMoreElements()) {
                        String string = en.nextElement().getName();
                        if (!string.toLowerCase().endsWith(".xml") && !string.toLowerCase().endsWith("device.txt") || string.toLowerCase().startsWith("meta-inf")) continue;
                        descriptorEntries.add(string);
                    }
                    jar.close();
                    urls[0] = file.toURL();
                }
                catch (IOException ex) {
                    Message.error("Error reading file: " + this.fileDialog.getFileName() + ", " + Message.getCauseMessage(ex), ex);
                    return;
                }
                if (descriptorEntries.size() == 0) {
                    Message.error("Cannot find any device profile in file: " + this.fileDialog.getFileName());
                    return;
                }
                if (descriptorEntries.size() > 1) {
                    manifestDeviceName = null;
                }
                ClassLoader classLoader = Common.createExtensionsClassLoader(urls);
                HashMap<String, DeviceImpl> devices = new HashMap<String, DeviceImpl>();
                for (JarEntry jarEntry : descriptorEntries) {
                    try {
                        devices.put(jarEntry.getName(), DeviceImpl.create(SwtSelectDeviceDialog.this.emulatorContext, classLoader, jarEntry.getName(), SwtDevice.class));
                    }
                    catch (IOException ex) {
                        Message.error("Error parsing device profile, " + Message.getCauseMessage(ex), ex);
                        return;
                    }
                }
                int i2 = 0;
                while (i2 < SwtSelectDeviceDialog.this.deviceModel.size()) {
                    DeviceEntry deviceEntry = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(i2);
                    if (devices.containsKey(deviceEntry.getDescriptorLocation())) {
                        devices.remove(deviceEntry.getDescriptorLocation());
                    }
                    ++i2;
                }
                if (devices.size() == 0) {
                    Message.info("Device profile already added");
                    return;
                }
                try {
                    File deviceFile = new File(Config.getConfigPath(), file.getName());
                    if (deviceFile.exists()) {
                        deviceFile = File.createTempFile("device", ".jar", Config.getConfigPath());
                    }
                    IOUtils.copyFile(file, deviceFile);
                    Object var9_18 = null;
                    for (String descriptorLocation : devices.keySet()) {
                        void var9_22;
                        Device device = (Device)devices.get(descriptorLocation);
                        if (manifestDeviceName != null) {
                            DeviceEntry deviceEntry = new DeviceEntry(manifestDeviceName, deviceFile.getName(), descriptorLocation, false);
                        } else {
                            DeviceEntry deviceEntry = new DeviceEntry(device.getName(), deviceFile.getName(), descriptorLocation, false);
                        }
                        SwtSelectDeviceDialog.this.deviceModel.addElement(var9_22);
                        int i3 = 0;
                        while (i3 < SwtSelectDeviceDialog.this.deviceModel.size()) {
                            if (SwtSelectDeviceDialog.this.deviceModel.elementAt(i3) == var9_22) {
                                SwtSelectDeviceDialog.this.lsDevices.add(var9_22.getName());
                                SwtSelectDeviceDialog.this.lsDevices.select(i3);
                            }
                            ++i3;
                        }
                        Config.addDeviceEntry((DeviceEntry)var9_22);
                    }
                    SwtSelectDeviceDialog.this.lsDevicesListener.widgetSelected(null);
                }
                catch (IOException ex) {
                    Message.error("Error adding device profile, " + Message.getCauseMessage(ex), ex);
                    return;
                }
            }
        }
    };
    private Listener btRemoveListener = new Listener(){

        public void handleEvent(Event event) {
            DeviceEntry entry = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(SwtSelectDeviceDialog.this.lsDevices.getSelectionIndex());
            boolean canDeleteFile = true;
            int i2 = 0;
            while (i2 < SwtSelectDeviceDialog.this.deviceModel.size()) {
                DeviceEntry test = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(i2);
                if (test != entry && test.getFileName() != null && test.getFileName().equals(entry.getFileName())) {
                    canDeleteFile = false;
                    break;
                }
                ++i2;
            }
            if (canDeleteFile) {
                File deviceFile = new File(Config.getConfigPath(), entry.getFileName());
                deviceFile.delete();
            }
            if (entry.isDefaultDevice()) {
                i = 0;
                while (i < SwtSelectDeviceDialog.this.deviceModel.size()) {
                    DeviceEntry tmp = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(i);
                    if (!tmp.canRemove()) {
                        tmp.setDefaultDevice(true);
                        SwtSelectDeviceDialog.this.lsDevices.setItem(i, String.valueOf(tmp.getName()) + " (default)");
                        break;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < SwtSelectDeviceDialog.this.deviceModel.size()) {
                if (SwtSelectDeviceDialog.this.deviceModel.elementAt(i) == entry) {
                    SwtSelectDeviceDialog.this.deviceModel.removeElementAt(i);
                    SwtSelectDeviceDialog.this.lsDevices.remove(i);
                    break;
                }
                ++i;
            }
            SwtSelectDeviceDialog.this.lsDevicesListener.widgetSelected(null);
            Config.removeDeviceEntry(entry);
        }
    };
    private Listener btDefaultListener = new Listener(){

        public void handleEvent(Event event) {
            DeviceEntry entry = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(SwtSelectDeviceDialog.this.lsDevices.getSelectionIndex());
            int i2 = 0;
            while (i2 < SwtSelectDeviceDialog.this.deviceModel.size()) {
                DeviceEntry tmp = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(i2);
                if (tmp == entry) {
                    tmp.setDefaultDevice(true);
                    SwtSelectDeviceDialog.this.lsDevices.setItem(i2, String.valueOf(tmp.getName()) + " (default)");
                } else {
                    tmp.setDefaultDevice(false);
                    SwtSelectDeviceDialog.this.lsDevices.setItem(i2, tmp.getName());
                }
                Config.changeDeviceEntry(tmp);
                ++i2;
            }
            SwtSelectDeviceDialog.this.btDefault.setEnabled(false);
        }
    };
    SelectionAdapter lsDevicesListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e2) {
            int index = SwtSelectDeviceDialog.this.lsDevices.getSelectionIndex();
            if (index != -1) {
                SwtSelectDeviceDialog.this.selectedEntry = (DeviceEntry)SwtSelectDeviceDialog.this.deviceModel.elementAt(index);
                if (SwtSelectDeviceDialog.this.selectedEntry.isDefaultDevice()) {
                    SwtSelectDeviceDialog.this.btDefault.setEnabled(false);
                } else {
                    SwtSelectDeviceDialog.this.btDefault.setEnabled(true);
                }
                if (SwtSelectDeviceDialog.this.selectedEntry.canRemove()) {
                    SwtSelectDeviceDialog.this.btRemove.setEnabled(true);
                } else {
                    SwtSelectDeviceDialog.this.btRemove.setEnabled(false);
                }
                SwtSelectDeviceDialog.this.btOk.setEnabled(true);
            } else {
                SwtSelectDeviceDialog.this.selectedEntry = null;
                SwtSelectDeviceDialog.this.btDefault.setEnabled(false);
                SwtSelectDeviceDialog.this.btRemove.setEnabled(false);
                SwtSelectDeviceDialog.this.btOk.setEnabled(false);
            }
        }
    };

    public SwtSelectDeviceDialog(Shell parent, EmulatorContext emulatorContext) {
        super(parent);
        this.emulatorContext = emulatorContext;
        Vector devs = Config.getDeviceEntries();
        int i2 = 0;
        while (i2 < devs.size()) {
            DeviceEntry entry = (DeviceEntry)devs.elementAt(i2);
            if (entry.isDefaultDevice()) {
                this.selectedEntry = entry;
            }
            ++i2;
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select device...");
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Group gpDevices = new Group(composite, 0);
        gpDevices.setText("Installed devices");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gpDevices.setLayout((Layout)gridLayout);
        gpDevices.setLayoutData((Object)new GridData(1808));
        this.lsDevices = new List((Composite)gpDevices, 516);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.grabExcessVerticalSpace = true;
        Rectangle trim = this.lsDevices.computeTrim(0, 0, 0, this.lsDevices.getItemHeight() * 5);
        gridData.heightHint = trim.height;
        this.lsDevices.setLayoutData((Object)gridData);
        this.lsDevices.addSelectionListener((SelectionListener)this.lsDevicesListener);
        Composite btDevices = new Composite((Composite)gpDevices, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        btDevices.setLayout((Layout)gridLayout);
        btDevices.setLayoutData((Object)new GridData(64));
        this.btAdd = new Button(btDevices, 8);
        this.btAdd.setText("Add...");
        this.btAdd.setLayoutData((Object)new GridData(64));
        this.btAdd.addListener(13, this.btAddListener);
        this.btRemove = new Button(btDevices, 8);
        this.btRemove.setText("Remove");
        this.btRemove.setLayoutData((Object)new GridData(64));
        this.btRemove.addListener(13, this.btRemoveListener);
        this.btDefault = new Button(btDevices, 8);
        this.btDefault.setText("Set as default");
        this.btDefault.setLayoutData((Object)new GridData(64));
        this.btDefault.addListener(13, this.btDefaultListener);
        Vector devs = Config.getDeviceEntries();
        this.deviceModel = new Vector();
        int i2 = 0;
        while (i2 < devs.size()) {
            DeviceEntry entry = (DeviceEntry)devs.elementAt(i2);
            this.deviceModel.addElement(entry);
            if (entry.isDefaultDevice()) {
                this.lsDevices.add(String.valueOf(entry.getName()) + " (default)");
                this.lsDevices.select(i2);
            } else {
                this.lsDevices.add(entry.getName());
            }
            ++i2;
        }
        return composite;
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.lsDevicesListener.widgetSelected(null);
        return control;
    }

    public DeviceEntry getSelectedDeviceEntry() {
        return this.selectedEntry;
    }
}

