/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.util.Map;
import java.util.WeakHashMap;
import org.microemu.MIDletBridge;
import org.microemu.MIDletContext;
import org.microemu.app.util.MIDletTimer;
import org.microemu.log.Logger;
import org.microemu.util.ThreadUtils;

public class MIDletThread
extends Thread {
    public static int graceTerminationPeriod = 5000;
    private static final String THREAD_NAME_PREFIX = "MIDletThread-";
    private static boolean terminator = false;
    private static Map midlets = new WeakHashMap();
    private static int threadInitNumber;
    private String callLocation;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public MIDletThread() {
        super(THREAD_NAME_PREFIX + MIDletThread.nextThreadNum());
        MIDletThread.register(this);
    }

    public MIDletThread(Runnable target) {
        super(target, THREAD_NAME_PREFIX + MIDletThread.nextThreadNum());
        MIDletThread.register(this);
    }

    public MIDletThread(Runnable target, String name) {
        super(target, THREAD_NAME_PREFIX + name);
        MIDletThread.register(this);
    }

    public MIDletThread(String name) {
        super(THREAD_NAME_PREFIX + name);
        MIDletThread.register(this);
    }

    private static void register(MIDletThread thread) {
        MIDletContext midletContext = MIDletBridge.getMIDletContext();
        if (midletContext == null) {
            Logger.error("Creating thread with no MIDlet context", new Throwable());
            return;
        }
        thread.callLocation = ThreadUtils.getCallLocation(MIDletThread.class.getName());
        WeakHashMap<MIDletThread, MIDletContext> threads = (WeakHashMap<MIDletThread, MIDletContext>)midlets.get(midletContext);
        if (threads == null) {
            threads = new WeakHashMap<MIDletThread, MIDletContext>();
            midlets.put(midletContext, threads);
        }
        threads.put(thread, midletContext);
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        catch (Throwable e2) {
            Logger.debug("MIDletThread throws", e2);
        }
    }

    public static void contextDestroyed(MIDletContext midletContext) {
        if (midletContext == null) {
            return;
        }
        final Map threads = (Map)midlets.remove(midletContext);
        if (threads != null && threads.size() != 0) {
            terminator = true;
            Thread terminator = new Thread("MIDletThreadsTerminator"){

                @Override
                public void run() {
                    MIDletThread.terminateThreads(threads);
                }
            };
            terminator.start();
        }
        MIDletTimer.contextDestroyed(midletContext);
    }

    public static boolean hasRunningThreads(MIDletContext midletContext) {
        return terminator;
    }

    private static void terminateThreads(Map threads) {
        long endTime = System.currentTimeMillis() + (long)graceTerminationPeriod;
        for (Object o2 : threads.keySet()) {
            if (o2 == null) continue;
            if (o2 instanceof MIDletThread) {
                MIDletThread t2 = (MIDletThread)o2;
                if (!t2.isAlive()) continue;
                Logger.info("wait thread [" + t2.getName() + "] end");
                while (endTime > System.currentTimeMillis() && t2.isAlive()) {
                    try {
                        t2.join(700L);
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                }
                if (!t2.isAlive()) continue;
                Logger.warn("MIDlet thread [" + t2.getName() + "] still running" + ThreadUtils.getTreadStackTrace(t2));
                if (t2.callLocation != null) {
                    Logger.info("this thread [" + t2.getName() + "] was created from " + t2.callLocation);
                }
                t2.interrupt();
                continue;
            }
            Logger.debug("unrecognized Object [" + o2.getClass().getName() + "]");
        }
        Logger.debug("all " + threads.size() + " thread(s) finished");
        terminator = false;
    }
}

