/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.datagram;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.BufferOverflowException;
import javax.microedition.io.Datagram;

public class DatagramImpl
implements Datagram {
    private DatagramPacket packet;
    private BufferOutputStream os;
    private DataOutputStream dos;
    private DataInputStream dis;

    DatagramImpl(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.packet = new DatagramPacket(new byte[size], size);
        this.initialiseInOut();
    }

    DatagramImpl(byte[] buff, int length) {
        this.packet = new DatagramPacket(buff, length);
        this.initialiseInOut();
    }

    private void initialiseInOut() {
        this.os = new BufferOutputStream();
        this.dos = new DataOutputStream(this.os);
        this.dis = new DataInputStream(new ByteArrayInputStream(this.packet.getData()));
    }

    @Override
    public String getAddress() {
        return String.valueOf(this.packet.getAddress().getCanonicalHostName()) + ":" + this.packet.getPort();
    }

    @Override
    public byte[] getData() {
        return this.packet.getData();
    }

    @Override
    public int getLength() {
        return this.packet.getLength();
    }

    @Override
    public int getOffset() {
        return this.packet.getOffset();
    }

    @Override
    public void reset() {
        try {
            this.os.reset();
            this.dis.reset();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setAddress(String address) throws IOException {
        if (address == null) {
            throw new NullPointerException("address cannot be null");
        }
        int index = address.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("Missing port in address: " + address);
        }
        String host = address.substring(0, index);
        String port = address.substring(index + 1);
        this.packet.setAddress(InetAddress.getByName(host));
        this.packet.setPort(Integer.parseInt(port));
    }

    @Override
    public void setAddress(Datagram reference) {
        this.packet.setAddress(((DatagramImpl)reference).getDatagramPacket().getAddress());
        this.packet.setPort(((DatagramImpl)reference).getDatagramPacket().getPort());
    }

    @Override
    public void setData(byte[] buffer, int offset, int len) {
        this.packet.setData(buffer, offset, len);
    }

    @Override
    public void setLength(int len) {
        this.packet.setLength(len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        this.dis.readFully(b2);
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        this.dis.read(b2, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return this.dis.skipBytes(n2);
    }

    @Override
    public void write(int b2) throws IOException {
        this.dos.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.dos.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.dos.write(b2, off, len);
    }

    @Override
    public void writeBoolean(boolean v2) throws IOException {
        this.dos.writeBoolean(v2);
    }

    @Override
    public void writeByte(int v2) throws IOException {
        this.dos.writeByte(v2);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        this.dos.writeBytes(s2);
    }

    @Override
    public void writeChar(int v2) throws IOException {
        this.dos.writeChar(v2);
    }

    @Override
    public void writeChars(String v2) throws IOException {
        this.dos.writeChars(v2);
    }

    @Override
    public void writeDouble(double v2) throws IOException {
        this.dos.writeDouble(v2);
    }

    @Override
    public void writeFloat(float v2) throws IOException {
        this.dos.writeFloat(v2);
    }

    @Override
    public void writeInt(int v2) throws IOException {
        this.dos.writeInt(v2);
    }

    @Override
    public void writeLong(long v2) throws IOException {
        this.dos.writeLong(v2);
    }

    @Override
    public void writeShort(int v2) throws IOException {
        this.dos.writeShort(v2);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.dos.writeUTF(str);
    }

    DatagramPacket getDatagramPacket() {
        return this.packet;
    }

    class BufferOutputStream
    extends OutputStream {
        private int originalOffset;
        private int offset;

        public BufferOutputStream() {
            this.offset = this.originalOffset = DatagramImpl.this.packet.getOffset();
        }

        @Override
        public void write(int b2) throws IOException {
            byte[] buffer = DatagramImpl.this.packet.getData();
            if (this.offset == buffer.length - 1) {
                throw new BufferOverflowException();
            }
            buffer[this.offset++] = (byte)b2;
        }

        public void reset() {
            this.offset = this.originalOffset;
        }
    }
}

