/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.microedition.io.HttpConnection;
import org.microemu.microedition.io.ConnectionImplementation;

public class Connection
implements HttpConnection,
ConnectionImplementation {
    protected URLConnection cn;
    protected boolean connected = false;
    protected static boolean allowNetworkConnection = true;

    @Override
    public javax.microedition.io.Connection openConnection(String name, int mode, boolean timeouts) throws IOException {
        URL url;
        if (!Connection.isAllowNetworkConnection()) {
            throw new IOException("No network");
        }
        try {
            url = new URL(name);
        }
        catch (MalformedURLException ex) {
            throw new IOException(ex.toString());
        }
        this.cn = url.openConnection();
        this.cn.setDoOutput(true);
        if (this.cn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.cn).setInstanceFollowRedirects(false);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.cn == null) {
            return;
        }
        if (this.cn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.cn).disconnect();
        }
        this.cn = null;
    }

    @Override
    public String getURL() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().toString();
    }

    @Override
    public String getProtocol() {
        return "http";
    }

    @Override
    public String getHost() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().getHost();
    }

    @Override
    public String getFile() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().getFile();
    }

    @Override
    public String getRef() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().getRef();
    }

    @Override
    public String getQuery() {
        if (this.cn == null) {
            return null;
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.cn == null) {
            return -1;
        }
        int port = this.cn.getURL().getPort();
        if (port == -1) {
            return 80;
        }
        return port;
    }

    @Override
    public String getRequestMethod() {
        if (this.cn == null) {
            return null;
        }
        if (this.cn instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.cn).getRequestMethod();
        }
        return null;
    }

    @Override
    public void setRequestMethod(String method) throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (method.equals("POST")) {
            this.cn.setDoOutput(true);
        }
        if (this.cn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.cn).setRequestMethod(method);
        }
    }

    @Override
    public String getRequestProperty(String key) {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getRequestProperty(key);
    }

    @Override
    public void setRequestProperty(String key, String value) throws IOException {
        if (this.cn == null || this.connected) {
            throw new IOException();
        }
        this.cn.setRequestProperty(key, value);
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        if (this.cn instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.cn).getResponseCode();
        }
        return -1;
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        if (this.cn instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.cn).getResponseMessage();
        }
        return null;
    }

    @Override
    public long getExpiration() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getExpiration();
    }

    @Override
    public long getDate() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getDate();
    }

    @Override
    public long getLastModified() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getLastModified();
    }

    @Override
    public String getHeaderField(String name) throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderField(name);
    }

    @Override
    public int getHeaderFieldInt(String name, int def) throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderFieldInt(name, def);
    }

    @Override
    public long getHeaderFieldDate(String name, long def) throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderFieldDate(name, def);
    }

    @Override
    public String getHeaderField(int n2) throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderField(this.getImplIndex(n2));
    }

    @Override
    public String getHeaderFieldKey(int n2) throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderFieldKey(this.getImplIndex(n2));
    }

    private int getImplIndex(int index) {
        if (this.cn.getHeaderFieldKey(0) == null && this.cn.getHeaderField(0) != null) {
            ++index;
        }
        return index;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        this.connected = true;
        return this.cn.getInputStream();
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.cn == null) {
            throw new IOException();
        }
        this.connected = true;
        return this.cn.getOutputStream();
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public String getType() {
        try {
            return this.getHeaderField("content-type");
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public String getEncoding() {
        try {
            return this.getHeaderField("content-encoding");
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public long getLength() {
        try {
            return this.getHeaderFieldInt("content-length", -1);
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public static boolean isAllowNetworkConnection() {
        return allowNetworkConnection;
    }

    public static void setAllowNetworkConnection(boolean allowNetworkConnection) {
        Connection.allowNetworkConnection = allowNetworkConnection;
    }
}

