/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.impl;

import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.Shape;

public class Polygon
extends Shape {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    private Rectangle bounds = new Rectangle();

    public Polygon() {
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        this.xpoints = new int[npoints];
        this.ypoints = new int[npoints];
        this.npoints = npoints;
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        int i2 = 0;
        while (i2 < npoints) {
            this.bounds.add(xpoints[i2], ypoints[i2]);
            ++i2;
        }
    }

    public Polygon(Polygon poly) {
        this(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public void addPoint(int x2, int y2) {
        if (this.npoints > 0) {
            int[] xtemp = this.xpoints;
            int[] ytemp = this.ypoints;
            this.xpoints = new int[this.npoints + 1];
            System.arraycopy(xtemp, 0, this.xpoints, 0, this.npoints);
            xtemp = null;
            this.ypoints = new int[this.npoints + 1];
            System.arraycopy(ytemp, 0, this.ypoints, 0, this.npoints);
            ytemp = null;
        } else {
            this.xpoints = new int[1];
            this.ypoints = new int[1];
        }
        ++this.npoints;
        this.xpoints[this.npoints - 1] = x2;
        this.ypoints[this.npoints - 1] = y2;
        this.bounds.add(x2, y2);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public boolean contains(int x2, int y2) {
        if (this.getBounds().contains(x2, y2)) {
            boolean c2 = false;
            int i2 = 0;
            int j2 = this.npoints - 1;
            while (i2 < this.npoints) {
                if ((this.ypoints[i2] <= y2 && y2 < this.ypoints[j2] || this.ypoints[j2] <= y2 && y2 < this.ypoints[i2]) && (double)x2 < (double)(this.xpoints[j2] - this.xpoints[i2]) * (double)(y2 - this.ypoints[i2]) / (double)(this.ypoints[j2] - this.ypoints[i2]) + (double)this.xpoints[i2]) {
                    c2 = !c2;
                }
                j2 = i2++;
            }
            return c2;
        }
        return false;
    }
}

