/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.microemu.app.ui.swt.ImageFilter;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.device.DeviceFactory;
import org.microemu.device.swt.SwtDeviceDisplay;

public final class GrayImageFilter
implements ImageFilter {
    private double Yr;
    private double Yg;
    private double Yb;
    private double Rr;
    private double Rg;
    private double Rb;
    private Color foregroundColor;

    public GrayImageFilter() {
        this(0.2126, 0.7152, 0.0722);
    }

    public GrayImageFilter(double Yr, double Yg, double Yb) {
        this.Yr = Yr;
        this.Yg = Yg;
        this.Yb = Yb;
        Color backgroundColor = SwtDeviceComponent.getColor(new RGB(((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getBackgroundColor().getRed(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getBackgroundColor().getGreen(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getBackgroundColor().getBlue()));
        this.foregroundColor = SwtDeviceComponent.getColor(new RGB(((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getForegroundColor().getRed(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getForegroundColor().getGreen(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getForegroundColor().getBlue()));
        this.Rr = (double)(backgroundColor.getRed() - this.foregroundColor.getRed()) / 256.0;
        this.Rg = (double)(backgroundColor.getGreen() - this.foregroundColor.getGreen()) / 256.0;
        this.Rb = (double)(backgroundColor.getBlue() - this.foregroundColor.getBlue()) / 256.0;
    }

    @Override
    public RGB filterRGB(int x2, int y2, RGB rgb) {
        int Y = (int)(this.Yr * (double)rgb.red + this.Yg * (double)rgb.green + this.Yb * (double)rgb.blue) % 256;
        if (Y > 255) {
            Y = 255;
        }
        return new RGB((int)(this.Rr * (double)Y) + this.foregroundColor.getRed(), (int)(this.Rg * (double)Y) + this.foregroundColor.getGreen(), (int)(this.Rb * (double)Y) + this.foregroundColor.getBlue());
    }
}

