/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.microemu.app.ui.swt.ImageFilter;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.device.DeviceFactory;
import org.microemu.device.swt.SwtDeviceDisplay;

public final class RGBImageFilter
implements ImageFilter {
    private double Rr;
    private double Rg;
    private double Rb;
    private Color backgroundColor = SwtDeviceComponent.getColor(new RGB(((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getBackgroundColor().getRed(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getBackgroundColor().getGreen(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getBackgroundColor().getBlue()));
    private Color foregroundColor = SwtDeviceComponent.getColor(new RGB(((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getForegroundColor().getRed(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getForegroundColor().getGreen(), ((SwtDeviceDisplay)DeviceFactory.getDevice().getDeviceDisplay()).getForegroundColor().getBlue()));

    public RGBImageFilter() {
        this.Rr = this.foregroundColor.getRed() - this.backgroundColor.getRed();
        this.Rg = this.foregroundColor.getGreen() - this.backgroundColor.getGreen();
        this.Rb = this.foregroundColor.getBlue() - this.backgroundColor.getBlue();
    }

    @Override
    public RGB filterRGB(int x2, int y2, RGB rgb) {
        int r2 = this.Rr > 0.0 ? (int)((double)rgb.red * this.Rr) / 255 + this.backgroundColor.getRed() : (int)((double)rgb.red * -this.Rr) / 255 + this.foregroundColor.getRed();
        int g2 = this.Rr > 0.0 ? (int)((double)rgb.green * this.Rg) / 255 + this.backgroundColor.getGreen() : (int)((double)rgb.green * -this.Rg) / 255 + this.foregroundColor.getGreen();
        int b2 = this.Rr > 0.0 ? (int)((double)rgb.blue * this.Rb) / 255 + this.backgroundColor.getBlue() : (int)((double)rgb.blue * -this.Rb) / 255 + this.foregroundColor.getBlue();
        return new RGB(r2, g2, b2);
    }
}

