/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import java.util.Hashtable;
import org.microemu.device.impl.Button;
import org.microemu.device.impl.Shape;

public class SwtButton
implements Button {
    String name;
    Shape shape;
    private int keyboardKey;
    private int keyCode;
    private Hashtable inputToChars;

    public SwtButton(String name, Shape shape, int keyCode, String keyName, Hashtable inputToChars) {
        this.name = name;
        this.shape = shape;
        this.keyboardKey = this.parseKeyboardKey(keyName);
        this.keyCode = keyCode == Integer.MIN_VALUE ? (keyName != null ? this.keyboardKey : -1) : keyCode;
        this.inputToChars = inputToChars;
    }

    public int getKeyboardKey() {
        return this.keyboardKey;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char[] getChars(int inputMode) {
        char[] result = null;
        switch (inputMode) {
            case 1: {
                result = (char[])this.inputToChars.get("123");
                break;
            }
            case 3: {
                result = (char[])this.inputToChars.get("abc");
                break;
            }
            case 2: {
                result = (char[])this.inputToChars.get("ABC");
            }
        }
        if (result == null) {
            result = (char[])this.inputToChars.get("common");
        }
        if (result == null) {
            result = new char[]{};
        }
        return result;
    }

    public boolean isChar(char c2, int inputMode) {
        c2 = Character.toLowerCase(c2);
        char[] chars = this.getChars(inputMode);
        if (chars != null) {
            int i2 = 0;
            while (i2 < chars.length) {
                if (c2 == Character.toLowerCase(chars[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Shape getShape() {
        return this.shape;
    }

    private int parseKeyboardKey(String keyName) {
        if (keyName == null) {
            return -1;
        }
        if (keyName.equals("VK_LEFT")) {
            return 0x1000003;
        }
        if (keyName.equals("VK_RIGHT")) {
            return 0x1000004;
        }
        if (keyName.equals("VK_UP")) {
            return 0x1000001;
        }
        if (keyName.equals("VK_DOWN")) {
            return 0x1000002;
        }
        if (keyName.equals("VK_ENTER")) {
            return 13;
        }
        if (keyName.equals("VK_F1")) {
            return 0x100000A;
        }
        if (keyName.equals("VK_F2")) {
            return 0x100000B;
        }
        if (keyName.equals("VK_0")) {
            return 48;
        }
        if (keyName.equals("VK_1")) {
            return 49;
        }
        if (keyName.equals("VK_2")) {
            return 50;
        }
        if (keyName.equals("VK_3")) {
            return 51;
        }
        if (keyName.equals("VK_4")) {
            return 52;
        }
        if (keyName.equals("VK_5")) {
            return 53;
        }
        if (keyName.equals("VK_6")) {
            return 54;
        }
        if (keyName.equals("VK_7")) {
            return 55;
        }
        if (keyName.equals("VK_8")) {
            return 56;
        }
        if (keyName.equals("VK_9")) {
            return 57;
        }
        if (keyName.equals("VK_MULTIPLY")) {
            return 42;
        }
        if (keyName.equals("VK_MODECHANGE")) {
            return 35;
        }
        try {
            return Integer.parseInt(keyName);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

