/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import javax.microedition.lcdui.Graphics;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.app.ui.swt.SwtGraphics;
import org.microemu.device.MutableImage;
import org.microemu.device.swt.SwtDisplayGraphics;

public class SwtMutableImage
extends MutableImage {
    public Image img;
    private GC gc;

    public SwtMutableImage(int width, int height) {
        this.img = SwtDeviceComponent.createImage(width, height);
        this.gc = new GC((Drawable)this.img);
        SwtDisplayGraphics displayGraphics = new SwtDisplayGraphics(new SwtGraphics(this.gc), this);
        displayGraphics.setColor(0xFFFFFF);
        displayGraphics.fillRect(0, 0, width, height);
    }

    @Override
    public Graphics getGraphics() {
        SwtDisplayGraphics displayGraphics = new SwtDisplayGraphics(new SwtGraphics(this.gc), this);
        displayGraphics.setColor(0);
        displayGraphics.setClip(0, 0, this.getWidth(), this.getHeight());
        displayGraphics.translate(-displayGraphics.getTranslateX(), -displayGraphics.getTranslateY());
        return displayGraphics;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public int getHeight() {
        return this.img.getBounds().height;
    }

    public Image getImage() {
        return this.img;
    }

    @Override
    public int getWidth() {
        return this.img.getBounds().width;
    }

    @Override
    public int[] getData() {
        byte[] tmp = this.img.getImageData().data;
        int[] result = new int[tmp.length];
        int i2 = 0;
        while (i2 < tmp.length) {
            result[i2] = tmp[i2];
            ++i2;
        }
        return result;
    }

    @Override
    public void getRGB(int[] argb, int offset, int scanlength, int x2, int y2, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x2 < 0 || y2 < 0 || x2 + width > this.getWidth() || y2 + height > this.getHeight()) {
            throw new IllegalArgumentException("Specified area exceeds bounds of image");
        }
        if ((scanlength < 0 ? -scanlength : scanlength) < width) {
            throw new IllegalArgumentException("abs value of scanlength is less than width");
        }
        if (argb == null) {
            throw new NullPointerException("null rgbData");
        }
        if (offset < 0 || offset + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (scanlength < 0 ? offset + scanlength * (height - 1) < 0 : offset + scanlength * (height - 1) + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ImageData imageData = this.img.getImageData();
        int i2 = 0;
        while (i2 < height) {
            imageData.getPixels(x2, y2 + i2, width, argb, offset + i2 * scanlength);
            ++i2;
        }
    }
}

