/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import org.eclipse.swt.graphics.Font;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.device.swt.SwtFont;

public class SwtSystemFont
implements SwtFont {
    private String name;
    private String style;
    private int size;
    private boolean antialiasing;
    private boolean initialized;
    private Font font;

    public SwtSystemFont(String name, String style, int size, boolean antialiasing) {
        this.name = name;
        this.style = style.toLowerCase();
        this.size = size;
        this.antialiasing = antialiasing;
        this.initialized = false;
    }

    @Override
    public void setAntialiasing(boolean antialiasing) {
        if (this.antialiasing != antialiasing) {
            this.antialiasing = antialiasing;
            this.initialized = false;
        }
    }

    @Override
    public Font getFont() {
        this.checkInitialized();
        return this.font;
    }

    private synchronized void checkInitialized() {
        if (!this.initialized) {
            int swtStyle = 0;
            if (this.style.indexOf("plain") != -1) {
                swtStyle |= 0;
            }
            if (this.style.indexOf("bold") != -1) {
                swtStyle |= 1;
            }
            if (this.style.indexOf("italic") != -1) {
                swtStyle |= 2;
            }
            this.style.indexOf("underlined");
            this.font = SwtDeviceComponent.getFont(this.name, this.size, swtStyle, this.antialiasing);
            this.initialized = true;
        }
    }

    @Override
    public int charWidth(char ch) {
        return this.charsWidth(new char[]{ch}, 0, 1);
    }

    @Override
    public int charsWidth(char[] ch, int offset, int length) {
        this.checkInitialized();
        return SwtDeviceComponent.stringWidth(this.font, new String(ch, offset, length));
    }

    @Override
    public int getBaselinePosition() {
        this.checkInitialized();
        return SwtDeviceComponent.getFontMetrics(this.font).getAscent();
    }

    @Override
    public int getHeight() {
        this.checkInitialized();
        return SwtDeviceComponent.getFontMetrics(this.font).getHeight();
    }

    @Override
    public int stringWidth(String str) {
        this.checkInitialized();
        return SwtDeviceComponent.stringWidth(this.font, str);
    }
}

