/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.util;

import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.microemu.util.JadMidletEntry;

public class JadProperties
extends Manifest {
    private static final long serialVersionUID = 1L;
    static String MIDLET_PREFIX = "MIDlet-";
    Vector midletEntries = null;
    String correctedJarURL = null;

    @Override
    public void clear() {
        super.clear();
        this.midletEntries = null;
        this.correctedJarURL = null;
    }

    public String getSuiteName() {
        return this.getProperty("MIDlet-Name");
    }

    public String getVersion() {
        return this.getProperty("MIDlet-Version");
    }

    public String getVendor() {
        return this.getProperty("MIDlet-Vendor");
    }

    public String getProfile() {
        return this.getProperty("MicroEdition-Profile");
    }

    public String getConfiguration() {
        return this.getProperty("MicroEdition-Configuration");
    }

    public String getJarURL() {
        if (this.correctedJarURL != null) {
            return this.correctedJarURL;
        }
        return this.getProperty("MIDlet-Jar-URL");
    }

    public void setCorrectedJarURL(String correctedJarURL) {
        this.correctedJarURL = correctedJarURL;
    }

    public int getJarSize() {
        return Integer.parseInt(this.getProperty("MIDlet-Jar-Size"));
    }

    public Vector getMidletEntries() {
        if (this.midletEntries == null) {
            this.midletEntries = new Vector();
            Attributes attributes = super.getMainAttributes();
            for (Attributes.Name name : attributes.keySet()) {
                if (!name.toString().startsWith(MIDLET_PREFIX)) continue;
                try {
                    Integer.parseInt(name.toString().substring(MIDLET_PREFIX.length()));
                    String test = this.getProperty(name.toString());
                    int pos = test.indexOf(44);
                    String name2 = test.substring(0, pos).trim();
                    String icon = test.substring(pos + 1, test.indexOf(44, pos + 1)).trim();
                    String className = test.substring(test.indexOf(44, pos + 1) + 1).trim();
                    this.midletEntries.addElement(new JadMidletEntry(name2, icon, className));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.midletEntries;
    }

    public String getProperty(String key, String defaultValue) {
        Attributes attributes = super.getMainAttributes();
        String result = null;
        try {
            result = attributes.getValue(key);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result != null) {
            return result.trim();
        }
        return defaultValue;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }
}

